package com.flybits.concierge.models;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

import com.bumptech.glide.Glide;
import com.bumptech.glide.load.DecodeFormat;
import com.bumptech.glide.request.RequestOptions;
import com.flybits.android.kernel.models.LocalizedValue;

public class Audio extends BaseTemplate implements Parcelable
{
    public String _id;
    public LocalizedValue title;
    public LocalizedValue description;
    public String duration;
    public String sourceURL;
    public String imageURL;

    public Audio()
    {

    }

    protected Audio(Parcel in) {
        _id = in.readString();
        title = in.readParcelable(LocalizedValue.class.getClassLoader());
        description = in.readParcelable(LocalizedValue.class.getClassLoader());
        duration = in.readString();
        sourceURL = in.readString();
        imageURL = in.readString();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(_id);
        dest.writeParcelable(title, flags);
        dest.writeParcelable(description, flags);
        dest.writeString(duration);
        dest.writeString(sourceURL);
        dest.writeString(imageURL);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static final Creator<Audio> CREATOR = new Creator<Audio>() {
        @Override
        public Audio createFromParcel(Parcel in) {
            return new Audio(in);
        }

        @Override
        public Audio[] newArray(int size) {
            return new Audio[size];
        }
    };

    public void populateViews(TextView txtTitle, TextView txtDescription, TextView txtDuration, ImageView imgImage)
    {
        txtTitle.setText(title.getValue());
        txtDescription.setText(description.getValue());
        txtDuration.setVisibility(!TextUtils.isEmpty(duration) ? View.VISIBLE : View.GONE);
        txtDuration.setText(duration);

        RequestOptions options = new RequestOptions().format(DecodeFormat.PREFER_RGB_565);

        Glide.with(imgImage.getContext())
                .load(imageURL)
                .apply(options)
                .into(imgImage);
    }
}
