package com.flybits.concierge.viewholders;

import android.support.v4.app.FragmentManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.widget.TextView;

import com.flybits.concierge.ConciergeFragment;
import com.flybits.concierge.R;
import com.flybits.concierge.models.BaseTemplate;
import com.flybits.concierge.models.Text;

public class TextViewHolder extends BaseViewHolder<Text> {

    private View thisView;
    private TextView txtHeading;
    private TextView txtBody;

    public TextViewHolder(ConciergeFragment conFrag, View itemView)
    {
        super(conFrag, itemView);
        this.thisView = itemView;
        this.txtHeading = itemView.findViewById(R.id.flybits_con_item_template_text_txtTitle);
        this.txtBody = itemView.findViewById(R.id.flybits_con_item_template_text_txtBody);
    }

    @Override
    public void bindData(Text data) {
        super.bindData(data);
        txtHeading.setText(data.header.getValue());
        txtBody.setText(data.description.getValue());
    }

}
