/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.concierge.viewholders;

import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.flybits.concierge.ConciergeFragment;
import com.flybits.concierge.R;
import com.flybits.concierge.fragments.ScheduleSegmentFragment;
import com.flybits.concierge.models.ScheduleSegment;
import com.flybits.concierge.viewholders.BaseViewHolder;

public class ScheduleSegmentViewHolder
extends BaseViewHolder<ScheduleSegment> {
    private final TextView timeRangeView;
    private final TextView titleView;
    private final View clickableArea;
    private final ConciergeFragment conciergeFragment;
    private final View ruleView;
    private final TextView descriptionView;
    private final ImageView bulletOutView;
    private final ImageView bulletInView;

    public ScheduleSegmentViewHolder(ConciergeFragment conciergeFragment, View itemView) {
        super(conciergeFragment, itemView);
        this.conciergeFragment = conciergeFragment;
        this.clickableArea = itemView.findViewById(R.id.flybits_con_item_template_schedule_segment_lytContainer);
        this.timeRangeView = (TextView)itemView.findViewById(R.id.flybits_con_item_template_schedule_segment_txtTimeRange);
        this.titleView = (TextView)itemView.findViewById(R.id.flybits_con_item_template_schedule_segment_txtTitle);
        this.descriptionView = (TextView)itemView.findViewById(R.id.flybits_con_item_template_schedule_segment_txtDescription);
        this.ruleView = itemView.findViewById(R.id.flybits_con_item_template_schedule_segment_viewRuleBottom);
        this.bulletOutView = (ImageView)itemView.findViewById(R.id.flybits_con_item_template_schedule_segment_imgBulletOut);
        this.bulletInView = (ImageView)itemView.findViewById(R.id.flybits_con_item_template_schedule_segment_imgBulletIn);
    }

    @Override
    public void bindData(final ScheduleSegment data) {
        this.clickableArea.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ScheduleSegmentFragment fragment = ScheduleSegmentFragment.newInstance(data);
                ScheduleSegmentViewHolder.this.conciergeFragment.openFragment(fragment);
            }
        });
        data.populateViews(this.timeRangeView, this.titleView, this.descriptionView, this.bulletOutView, this.bulletInView, this.clickableArea);
    }

    public void setLast(boolean last) {
        this.ruleView.setVisibility(last ? 4 : 0);
    }
}

