package com.flybits.concierge.viewholders;

import android.view.LayoutInflater;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.flybits.concierge.ConciergeFragment;
import com.flybits.concierge.R;
import com.flybits.concierge.models.Link;
import com.flybits.concierge.models.Links;

public class LinksViewHolder extends BaseViewHolder<Links>
{

    private LinearLayout thisView;

    public LinksViewHolder(ConciergeFragment conFrag, View view)
    {
        super(conFrag, view);
        this.thisView = (LinearLayout) view;
    }

    @Override
    public void bindData(Links data)
    {
        // remove all views
        thisView.removeAllViews();

        boolean shouldAddRule = false;

        for (Link link : data.links.getList())
        {
            View linkView = LayoutInflater.from(thisView.getContext()).inflate(R.layout.flybits_con_item_template_link, thisView, false);

            TextView txtHeading = linkView.findViewById(R.id.flybits_con_item_template_link_txtTitle);
            TextView txtBody = linkView.findViewById(R.id.flybits_con_item_template_link_txtBody);
            View hr = linkView.findViewById(R.id.flybits_con_item_template_link_viewRule);

            hr.setVisibility(shouldAddRule ? View.VISIBLE : View.GONE);
            shouldAddRule = true;

            link.populateViews(txtHeading, txtBody, linkView);

            thisView.addView(linkView);
        }
    }

}
