package com.flybits.concierge.viewholders;

import android.support.v4.view.ViewPager;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

import com.flybits.concierge.ConciergeFragment;
import com.flybits.concierge.R;
import com.flybits.concierge.adapters.ArticleAdapter;
import com.flybits.concierge.models.Article;
import com.flybits.concierge.models.Articles;

import java.util.List;

public class ArticlesViewHolder extends BaseViewHolder<Articles>
{
    private ViewPager viewPager;
    private View singleView;
    private ImageView imgHeader;
    private TextView txtTitle;
    private TextView txtSource;
    private TextView txtDescription;
    private View thisView;

    public ArticlesViewHolder(ConciergeFragment conciergeFragment, View itemView)
    {
        super(conciergeFragment, itemView);
        viewPager = itemView.findViewById(R.id.flybits_con_articles_viewPager);
        singleView = itemView.findViewById(R.id.flybits_con_articles_single);
        thisView = itemView;

        // single elements
        imgHeader = (ImageView) itemView.findViewById(R.id.flybits_con_article_imgHeader);
        txtTitle = (TextView) itemView.findViewById(R.id.flybits_con_article_txtTitle);
        txtSource = (TextView) itemView.findViewById(R.id.flybits_con_article_txtSource);
        txtDescription = (TextView) itemView.findViewById(R.id.flybits_con_article_txtDescription);


        // Disable clip to padding
        viewPager.setClipToPadding(false);
        // set padding manually, the more you set the padding the more you see of prev & next page
        viewPager.setPadding(50, 0, 50, 0);
        // sets a margin b/w individual pages to ensure that there is a gap b/w them
        viewPager.setPageMargin(5);
    }

    @Override
    public void bindData(Articles data)
    {
        viewPager.setVisibility(View.GONE);
        singleView.setVisibility(View.GONE);
        List<Article> articleList = data.articles.getList();

        if (articleList.size() > 1)
        {
            viewPager.setVisibility(View.VISIBLE);
            ArticleAdapter adapter = new ArticleAdapter();
            viewPager.setAdapter(adapter);
            adapter.setData(data.articles.getList());
        }
        else if (articleList.size() == 1)
        {
            singleView.setVisibility(View.VISIBLE);
            articleList.get(0).populateViews(imgHeader, txtTitle, txtSource, txtDescription, thisView);
        }
    }

    public void setPagerId(int position)
    {
        viewPager.setId(position);
    }
}
