package com.flybits.concierge.adapters;

import android.arch.paging.PagedList;
import android.arch.paging.PagedListAdapter;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.support.v7.util.DiffUtil;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.TextView;

import com.flybits.concierge.ConciergeFragment;
import com.flybits.concierge.R;
import com.flybits.concierge.enums.FeedView;
import com.flybits.concierge.models.BaseTemplate;
import com.flybits.concierge.viewholders.ArticlesViewHolder;
import com.flybits.concierge.viewholders.AudiosViewHolder;
import com.flybits.concierge.viewholders.BaseViewHolder;
import com.flybits.concierge.viewholders.EventsViewHolder;
import com.flybits.concierge.viewholders.ImageViewHolder;
import com.flybits.concierge.viewholders.LinksViewHolder;
import com.flybits.concierge.viewholders.OnboardingViewHolder;
import com.flybits.concierge.viewholders.ScheduleViewHolder;
import com.flybits.concierge.viewholders.SurveyViewHolder;
import com.flybits.concierge.viewholders.TextViewHolder;
import com.flybits.concierge.viewholders.TwitterViewHolder;
import com.flybits.concierge.viewholders.UnknownViewHolder;
import com.flybits.concierge.viewholders.VideosViewHolder;

import java.util.ArrayList;
import java.util.List;

public class FeedAdapter extends PagedListAdapter<BaseTemplate, BaseViewHolder>
{
    private ConciergeFragment conFrag;

    private static final DiffUtil.ItemCallback<BaseTemplate> ITEM_CALLBACK = new DiffUtil.ItemCallback<BaseTemplate>() {
        @Override
        public boolean areItemsTheSame(BaseTemplate oldItem, BaseTemplate newItem) {
            return oldItem.getContent().getId().equals(newItem.getContent().getId());
        }

        @Override
        public boolean areContentsTheSame(BaseTemplate oldItem, BaseTemplate newItem) {
            return oldItem.getContent().equals(newItem.getContent());

        }
    };

    public FeedAdapter(ConciergeFragment conFrag)
    {
        //This is how codelabs does it, the tutorial referenced by android: https://codelabs.developers.google.com/codelabs/android-paging/#0
        super(ITEM_CALLBACK);
        this.conFrag = conFrag;
    }

    @NonNull
    @Override
    public BaseViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType)
    {
        switch (FeedView.values()[viewType])
        {
            case ARTICLES:
                return new ArticlesViewHolder(conFrag, LayoutInflater.from(parent.getContext()).inflate(R.layout.flybits_con_item_articles, parent, false));
            case SCHEDULE:
                return new ScheduleViewHolder(conFrag, LayoutInflater.from(parent.getContext()).inflate(R.layout.flybits_con_item_template_schedule, parent, false));
            case TEXT:
                return new TextViewHolder(conFrag, LayoutInflater.from(parent.getContext()).inflate(R.layout.flybits_con_item_text, parent, false));
            case ONBOARDING:
                return new OnboardingViewHolder(conFrag, LayoutInflater.from(parent.getContext()).inflate(R.layout.flybits_con_item_on_boarding, parent, false));
            case VIDEOS:
                return new VideosViewHolder(conFrag, LayoutInflater.from(parent.getContext()).inflate(R.layout.flybits_con_item_template_videos, parent, false));
            case IMAGES:
                return new ImageViewHolder(conFrag, LayoutInflater.from(parent.getContext()).inflate(R.layout.flybits_con_item_image, parent, false));
            case SURVEY:
                return new SurveyViewHolder(conFrag, LayoutInflater.from(parent.getContext()).inflate(R.layout.flybits_con_item_survey, parent, false));
            case LINKS:
                return new LinksViewHolder(conFrag, LayoutInflater.from(parent.getContext()).inflate(R.layout.flybits_con_item_template_links, parent, false));
            case EVENTS:
                return new EventsViewHolder(conFrag, LayoutInflater.from(parent.getContext()).inflate(R.layout.flybits_con_item_template_events, parent, false));
            case AUDIOS:
                return new AudiosViewHolder(conFrag, LayoutInflater.from(parent.getContext()).inflate(R.layout.flybits_con_item_template_audios, parent, false));
            case TWITTERS:
                return new TwitterViewHolder(conFrag, LayoutInflater.from(parent.getContext()).inflate(R.layout.flybits_con_item_template_twitter, parent, false));
        }

        // if all else fails, display what kind of content type this is.
        TextView textView = (TextView) LayoutInflater.from(parent.getContext()).inflate(android.R.layout.simple_list_item_1, parent, false);
        textView.setTextColor(ContextCompat.getColor(parent.getContext(), R.color.flybits_con_primary));
        return new UnknownViewHolder(conFrag, textView);
    }

    @Override
    public void onBindViewHolder(@NonNull BaseViewHolder holder, int position)
    {
        holder.bindData(getItem(position));
        if (holder instanceof ArticlesViewHolder)
        {
            ArticlesViewHolder articlesHolder = (ArticlesViewHolder) holder;
            articlesHolder.setPagerId(position);
        }
    }

    @Override
    public int getItemCount()
    {
        return getCurrentList().size();
    }

    @Override
    public int getItemViewType(int position)
    {
        BaseTemplate dataClass = getItem(position);
        return dataClass == null? 0 : dataClass.getType().ordinal();
    }

    @Override
    public long getItemId(int position)
    {
        return getItem(position).getContent().getCreatedAt();
    }
}
