package com.flybits.concierge.viewholders;

import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.flybits.concierge.ConciergeFragment;
import com.flybits.concierge.R;
import com.flybits.concierge.models.Event;
import com.flybits.concierge.models.Events;

public class EventsViewHolder extends BaseViewHolder<Events>
{
    private final LinearLayout thisView;
    ConciergeFragment conciergeFragment;

    public EventsViewHolder(ConciergeFragment conFrag, View itemView)
    {
        super(conFrag, itemView);
        thisView = (LinearLayout) itemView;
        conciergeFragment = conFrag;
    }

    @Override
    public void bindData(Events data)
    {
        thisView.removeAllViews();

        for (Event event : data.events.getList())
        {
            View eventView = LayoutInflater.from(thisView.getContext()).inflate(R.layout.flybits_con_item_template_event_item, thisView, false);

            ImageView imgHeader = (ImageView) eventView.findViewById(R.id.flybits_con_events_item_imgHeader);
            TextView txtTitle = (TextView) eventView.findViewById(R.id.flybits_con_events_item_txtTitle);
            TextView txtLocation = (TextView) eventView.findViewById(R.id.flybits_con_events_item_txtLocation);
            TextView txtDate = (TextView) eventView.findViewById(R.id.flybits_con_events_item_txtDate);

            event.populateViews(conciergeFragment, txtTitle, txtLocation, txtDate, imgHeader, eventView);

            thisView.addView(eventView);
        }
    }
}
