package com.flybits.concierge.models;

import android.os.Parcel;
import android.os.Parcelable;

import com.flybits.android.kernel.models.PagedArray;
import com.flybits.android.kernel.reservedtemplates.survey.models.Question;
import com.flybits.concierge.enums.FeedView;

public class Survey extends BaseTemplate implements Parcelable
{
    public Survey()
    {
    }

    public String _id;
    public String resultId;
    public PagedArray<Question> questions;

    protected Survey(Parcel in)
    {
        _id = in.readString();
        resultId = in.readString();
        questions = in.readParcelable(PagedArray.class.getClassLoader());
    }

    public static final Creator<Survey> CREATOR = new Creator<Survey>()
    {
        @Override
        public Survey createFromParcel(Parcel in)
        {
            return new Survey(in);
        }

        @Override
        public Survey[] newArray(int size)
        {
            return new Survey[size];
        }
    };

    @Override
    public FeedView getType() {
        return FeedView.SURVEY;
    }

    @Override
    public int describeContents()
    {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags)
    {
        dest.writeString(_id);
        dest.writeString(resultId);
        dest.writeParcelable(questions, flags);
    }
}
