package com.flybits.concierge.models;

import android.os.Parcel;
import android.os.Parcelable;
import android.widget.ImageView;
import android.widget.TextView;

import com.bumptech.glide.Glide;
import com.bumptech.glide.load.DecodeFormat;
import com.bumptech.glide.request.RequestOptions;
import com.flybits.android.kernel.models.LocalizedValue;
import com.flybits.concierge.R;
import com.flybits.concierge.enums.FeedView;

import java.util.Locale;

public class OnboardingPage extends BaseTemplate implements Parcelable
{
    public LocalizedValue title;
    public LocalizedValue description;
    public String imageUrl;

    public OnboardingPage()
    {
    }

    protected OnboardingPage(Parcel in)
    {
        title = in.readParcelable(LocalizedValue.class.getClassLoader());
        description = in.readParcelable(LocalizedValue.class.getClassLoader());
        imageUrl = in.readString();
    }

    public static final Creator<OnboardingPage> CREATOR = new Creator<OnboardingPage>()
    {
        @Override
        public OnboardingPage createFromParcel(Parcel in)
        {
            return new OnboardingPage(in);
        }

        @Override
        public OnboardingPage[] newArray(int size)
        {
            return new OnboardingPage[size];
        }
    };

    @Override
    public FeedView getType() {
        return FeedView.ONBOARDING_PAGE;
    }

    @Override
    public int describeContents()
    {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags)
    {
        dest.writeParcelable(title, flags);
        dest.writeParcelable(description, flags);
        dest.writeString(imageUrl);
    }

    public void populateViews(TextView titleTextView)
    {
        String onBoardingTitle = title.getValue();

        String displayedTitle = String.format(Locale.getDefault(), titleTextView.getContext().getString(R.string.flybits_con_item_template_on_boarding_title_format), onBoardingTitle);

        titleTextView.setText(displayedTitle);
    }

    public void populateViews(TextView titleTextView, TextView bodyTextView, ImageView logoImageView)
    {
        titleTextView.setText(title.getValue());
        bodyTextView.setText(description.getValue());

        RequestOptions options = new RequestOptions().format(DecodeFormat.PREFER_RGB_565);

        Glide.with(logoImageView.getContext())
                .load(imageUrl)
                .apply(options)
                .into(logoImageView);
    }
}
