package com.flybits.concierge.models;

import android.content.Intent;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.view.View;
import android.widget.TextView;

import com.flybits.android.kernel.models.LocalizedValue;
import com.flybits.android.kernel.models.PagedArray;
import com.flybits.concierge.enums.FeedView;

public class Link extends BaseTemplate implements Parcelable
{
    public Link()
    {
    }

    public LocalizedValue title;
    public LocalizedValue description;
    public String url;

    protected Link(Parcel in)
    {
        title = in.readParcelable(LocalizedValue.class.getClassLoader());
        description = in.readParcelable(LocalizedValue.class.getClassLoader());
        url = in.readString();
    }

    public static final Creator<Link> CREATOR = new Creator<Link>()
    {
        @Override
        public Link createFromParcel(Parcel in)
        {
            return new Link(in);
        }

        @Override
        public Link[] newArray(int size)
        {
            return new Link[size];
        }
    };

    @Override
    public FeedView getType()
    {
        return FeedView.LINK;
    }


    @Override
    public int describeContents()
    {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags)
    {
        dest.writeParcelable(title, flags);
        dest.writeParcelable(description, flags);
        dest.writeString(url);
    }

    public void populateViews(TextView txtHeading, TextView txtBody, View linkView)
    {
        txtHeading.setText(!TextUtils.isEmpty(title.getValue()) ? title.getValue() : "");

        txtBody.setText(!TextUtils.isEmpty(description.getValue()) ? description.getValue() : "");
        txtBody.setVisibility(TextUtils.isEmpty(description.getValue()) ? View.GONE : View.VISIBLE);

        linkView.setOnClickListener(new View.OnClickListener()
        {
            @Override
            public void onClick(View v)
            {
                String url = Link.this.url;
                Intent intent = new Intent(Intent.ACTION_VIEW);
                intent.setData(Uri.parse(url));
                v.getContext().startActivity(intent);
            }
        });
    }
}
