/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.concierge.viewholders;

import android.content.Context;
import android.support.v4.media.session.MediaControllerCompat;
import android.support.v4.media.session.PlaybackStateCompat;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.flybits.commons.library.logging.Logger;
import com.flybits.concierge.ConciergeFragment;
import com.flybits.concierge.R;
import com.flybits.concierge.models.Audio;
import com.flybits.concierge.models.Audios;
import com.flybits.concierge.services.AudioService;
import com.flybits.concierge.viewholders.BaseViewHolder;
import java.util.ArrayList;

public class AudiosViewHolder
extends BaseViewHolder<Audios> {
    private ConciergeFragment conciergeFragment;
    private LinearLayout thisView;

    public AudiosViewHolder(ConciergeFragment conFrag, View itemView) {
        super(conFrag, itemView);
        this.conciergeFragment = conFrag;
        this.thisView = (LinearLayout)itemView;
    }

    @Override
    public void bindData(Audios data) {
        super.bindData(data);
        ArrayList audioList = data.audios.getList();
        this.thisView.removeAllViews();
        for (final Audio audio : audioList) {
            View view = LayoutInflater.from((Context)this.thisView.getContext()).inflate(R.layout.flybits_con_item_template_audio, (ViewGroup)this.thisView, false);
            ImageView imgImage = (ImageView)view.findViewById(R.id.flybits_con_audio_imgImage);
            final ImageView imgMediaStatusPlayPause = (ImageView)view.findViewById(R.id.flybits_con_audio_imgMediaStatusPlayPause);
            ImageView imgMediaStatusStop = (ImageView)view.findViewById(R.id.flybits_con_audio_imgMediaStatusStop);
            TextView txtTitle = (TextView)view.findViewById(R.id.flybits_con_audio_txtTitle);
            TextView txtDescription = (TextView)view.findViewById(R.id.flybits_con_audio_txtDescription);
            TextView txtDuration = (TextView)view.findViewById(R.id.flybits_con_audio_txtDuration);
            audio.populateViews(txtTitle, txtDescription, txtDuration, imgImage);
            String playingURL = this.conciergeFragment.getCurrentAudio() != null && this.conciergeFragment.getCurrentAudio().sourceURL != null ? this.conciergeFragment.getCurrentAudio().sourceURL : AudioService.getPlayingURL();
            int playingState = AudioService.getPlayingState();
            if (playingURL != null && playingURL.contentEquals(audio.sourceURL)) {
                if (playingState == 0 || playingState == 1) {
                    imgMediaStatusPlayPause.setImageResource(R.drawable.ic_baseline_play_arrow_24px);
                } else if (playingState == 2) {
                    imgMediaStatusPlayPause.setImageResource(R.drawable.ic_baseline_play_arrow_24px);
                } else if (playingState == 3) {
                    imgMediaStatusStop.setVisibility(0);
                    imgMediaStatusPlayPause.setImageResource(R.drawable.ic_baseline_pause_24px);
                }
            }
            this.conciergeFragment.registerMediaControllerCallback(new MediaControllerCompat.Callback(){

                public void onPlaybackStateChanged(PlaybackStateCompat state) {
                    super.onPlaybackStateChanged(state);
                    try {
                        switch (state.getState()) {
                            case 0: {
                                imgMediaStatusPlayPause.setImageResource(R.drawable.ic_baseline_play_arrow_24px);
                                break;
                            }
                            case 1: {
                                imgMediaStatusPlayPause.setImageResource(R.drawable.ic_baseline_play_arrow_24px);
                                break;
                            }
                            case 3: {
                                imgMediaStatusPlayPause.setImageResource(R.drawable.ic_baseline_pause_24px);
                                break;
                            }
                            case 2: {
                                imgMediaStatusPlayPause.setImageResource(R.drawable.ic_baseline_play_arrow_24px);
                            }
                        }
                    }
                    catch (Exception e) {
                        Logger.exception((String)"AudiosViewHolder.bindData()", (Exception)e);
                    }
                }
            });
            imgMediaStatusPlayPause.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    if (AudiosViewHolder.this.conciergeFragment.getCurrentAudio() != null && ((AudiosViewHolder)AudiosViewHolder.this).conciergeFragment.getCurrentAudio().sourceURL != null && ((AudiosViewHolder)AudiosViewHolder.this).conciergeFragment.getCurrentAudio().sourceURL.equals(audio.sourceURL) && AudiosViewHolder.this.conciergeFragment.getAudioState() == 3) {
                        AudiosViewHolder.this.conciergeFragment.pauseAudio();
                    } else if (AudiosViewHolder.this.conciergeFragment.getCurrentAudio() != null && ((AudiosViewHolder)AudiosViewHolder.this).conciergeFragment.getCurrentAudio().sourceURL != null && ((AudiosViewHolder)AudiosViewHolder.this).conciergeFragment.getCurrentAudio().sourceURL.equals(audio.sourceURL) && AudiosViewHolder.this.conciergeFragment.getAudioState() == 2) {
                        AudiosViewHolder.this.conciergeFragment.resumeAudio();
                    } else if (AudiosViewHolder.this.conciergeFragment.getAudioState() == 0 || AudiosViewHolder.this.conciergeFragment.getAudioState() == 1) {
                        AudiosViewHolder.this.conciergeFragment.startAudio(audio);
                    }
                }
            });
            imgMediaStatusStop.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    AudiosViewHolder.this.conciergeFragment.stopAudio();
                }
            });
            this.thisView.addView(view);
        }
    }
}

