/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.concierge.fragments;

import android.app.Activity;
import android.arch.lifecycle.ViewModelProviders;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.design.widget.TabLayout;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentPagerAdapter;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.LongSparseArray;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.LinearLayout;
import com.afollestad.materialdialogs.MaterialDialog;
import com.flybits.android.kernel.reservedtemplates.survey.models.Answer;
import com.flybits.android.kernel.reservedtemplates.survey.models.Question;
import com.flybits.android.kernel.reservedtemplates.survey.models.QuestionChoice;
import com.flybits.android.kernel.reservedtemplates.survey.models.SurveyAnswer;
import com.flybits.commons.library.api.results.callbacks.BasicResultCallback;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.logging.Logger;
import com.flybits.concierge.R;
import com.flybits.concierge.Utils;
import com.flybits.concierge.enums.QuestionType;
import com.flybits.concierge.enums.QuestionUIType;
import com.flybits.concierge.fragments.QuestionFragment;
import com.flybits.concierge.models.Survey;
import com.flybits.concierge.viewmodels.SurveyViewModel;
import com.flybits.concierge.views.CustomTabsViewPager;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public class SurveyFragment
extends Fragment {
    private static final String ARG_PARAM_SURVEY = "flybits_con_arg_survey";
    private SurveyViewModel surveyViewModel;
    private Survey survey;
    private CustomTabsViewPager viewPager;
    private TabLayout tabLayout;
    private Button btnBack;
    private Button btnNext;
    private MaterialDialog progressDialog;
    private Handler uiHandler;

    public static SurveyFragment newInstance(Survey survey) {
        SurveyFragment fragment = new SurveyFragment();
        Bundle args = new Bundle();
        args.putParcelable(ARG_PARAM_SURVEY, (Parcelable)survey);
        fragment.setArguments(args);
        return fragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.getArguments() != null) {
            this.survey = (Survey)this.getArguments().getParcelable(ARG_PARAM_SURVEY);
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.flybits_con_fragment_survey, container, false);
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.uiHandler = new Handler(Looper.getMainLooper());
        this.surveyViewModel = (SurveyViewModel)ViewModelProviders.of((FragmentActivity)this.getActivity()).get(SurveyViewModel.class);
        this.viewPager = (CustomTabsViewPager)view.findViewById(R.id.flybits_con_fragment_survey_lytPager);
        SurveyPagerAdapter adapter = new SurveyPagerAdapter(this.getChildFragmentManager());
        this.viewPager.setAdapter((PagerAdapter)adapter);
        this.viewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            }

            public void onPageSelected(int position) {
                SurveyFragment.this.changeState();
            }

            public void onPageScrollStateChanged(int state) {
            }
        });
        this.tabLayout = (TabLayout)view.findViewById(R.id.flybits_con_fragment_survey_lytTabs);
        this.tabLayout.setupWithViewPager((ViewPager)this.viewPager);
        View.OnTouchListener disabledListener = new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                return true;
            }
        };
        LinearLayout tabStrip = (LinearLayout)this.tabLayout.getChildAt(0);
        for (int i = 0; i < tabStrip.getChildCount(); ++i) {
            tabStrip.getChildAt(i).setOnTouchListener(disabledListener);
        }
        this.btnBack = (Button)view.findViewById(R.id.flybits_con_fragment_survey_btnBack);
        this.btnBack.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                int current = SurveyFragment.this.viewPager.getCurrentItem();
                if (current == 0) {
                    return;
                }
                SurveyFragment.this.viewPager.setCurrentItem(current - 1);
                Utils.dismissKeyboard((Activity)SurveyFragment.this.getActivity());
            }
        });
        this.btnNext = (Button)view.findViewById(R.id.flybits_con_fragment_survey_btnNext);
        this.btnNext.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                int current = SurveyFragment.this.viewPager.getCurrentItem();
                Question question = (Question)((SurveyFragment)SurveyFragment.this).survey.questions.getList().get(current);
                try {
                    Object answer = SurveyFragment.this.surveyViewModel.getAnswers().get(question.questionNumber.longValue());
                    FragmentActivity activity = SurveyFragment.this.getActivity();
                    if (question.getMetadata().getBoolean("isRequired") && answer == null && activity != null) {
                        new MaterialDialog.Builder((Context)activity).title(R.string.flybits_con_fragment_survey_required).content((CharSequence)String.format(Locale.getDefault(), SurveyFragment.this.getString(R.string.flybits_con_fragment_survey_required_message_format), current + 1)).positiveText(17039370).show();
                        return;
                    }
                }
                catch (Exception e) {
                    Logger.exception((String)SurveyFragment.class.getSimpleName(), (Exception)e);
                }
                if (current == SurveyFragment.this.viewPager.getAdapter().getCount() - 1) {
                    SurveyFragment.this.submitAnswers();
                    return;
                }
                SurveyFragment.this.viewPager.setCurrentItem(current + 1);
                Utils.dismissKeyboard((Activity)SurveyFragment.this.getActivity());
            }
        });
        this.changeState();
        BasicResultCallback resultCallback = new BasicResultCallback(){

            public void onSuccess() {
                SurveyFragment.this.uiHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        FragmentActivity activity = SurveyFragment.this.getActivity();
                        if (activity != null) {
                            SurveyFragment.this.progressDialog.dismiss();
                            new MaterialDialog.Builder((Context)activity).title(R.string.flybits_con_thank_you).content(R.string.flybits_con_fragment_survey_message_success).positiveText(17039370).show();
                            SurveyFragment.this.surveyViewModel.getAnswers().clear();
                            SurveyFragment.this.getFragmentManager().popBackStack();
                        }
                    }
                });
            }

            public void onException(final FlybitsException exception) {
                SurveyFragment.this.uiHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        FragmentActivity activity = SurveyFragment.this.getActivity();
                        if (activity != null) {
                            SurveyFragment.this.progressDialog.dismiss();
                            new MaterialDialog.Builder((Context)activity).title(R.string.flybits_con_sorry).content((CharSequence)(SurveyFragment.this.getString(R.string.flybits_con_fragment_survey_message_failed) + exception.getLocalizedMessage())).positiveText(17039370).show();
                        }
                    }
                });
            }
        };
        this.surveyViewModel.setBasicResultCallback(resultCallback);
        this.progressDialog = new MaterialDialog.Builder(this.getContext()).title(R.string.flybits_con_dialog_loading_title).content(R.string.flybits_con_dialog_loading_message).progress(true, 0).build();
    }

    public void onResume() {
        super.onResume();
        if (this.surveyViewModel.isSubmitting()) {
            this.progressDialog.show();
        }
    }

    private void submitAnswers() {
        ArrayList<Answer> submittedAnswers = new ArrayList<Answer>();
        LongSparseArray<Object> answers = this.surveyViewModel.getAnswers();
        for (int i = 0; i < this.survey.questions.getList().size(); ++i) {
            Question question = (Question)this.survey.questions.getList().get(i);
            Object answer = answers.get(question.questionNumber.longValue());
            if (answer == null) continue;
            QuestionType questionType = QuestionType.fromString(question.type);
            QuestionUIType questionUIType = QuestionUIType.UNKNOWN;
            try {
                questionUIType = QuestionUIType.fromString(question.getMetadata().get("uiType").toString());
            }
            catch (JSONException e) {
                Logger.exception((String)SurveyFragment.class.getSimpleName(), (Exception)((Object)e));
            }
            Answer preparedAnswer = new Answer(question.questionNumber.longValue());
            switch (questionType) {
                case STRING: 
                case NUMBER: {
                    if (answer instanceof Calendar) {
                        Calendar calendar = (Calendar)answer;
                        if (questionUIType == QuestionUIType.DATE) {
                            preparedAnswer.addAnswer(Utils.getDateString(calendar.getTime()));
                            break;
                        }
                        if (questionUIType != QuestionUIType.TIME) break;
                        preparedAnswer.addAnswer(Utils.getTimeString(calendar.getTime()));
                        break;
                    }
                    if (questionUIType == QuestionUIType.LOCATION) {
                        try {
                            JSONObject jsonObject = new JSONObject(answer.toString());
                            String locationName = jsonObject.getString("name");
                            preparedAnswer.addAnswer(locationName);
                        }
                        catch (JSONException e) {
                            Logger.exception((String)SurveyFragment.class.getSimpleName(), (Exception)((Object)e));
                        }
                        break;
                    }
                    preparedAnswer.addAnswer(answer.toString());
                    break;
                }
                case SINGLE: {
                    preparedAnswer.addAnswer(((QuestionChoice)question.choices.get((int)((Integer)answer).intValue())).value.getValue());
                    break;
                }
                case MULTIPLE: {
                    List list = (List)answer;
                    for (Integer selection : list) {
                        preparedAnswer.addAnswer(((QuestionChoice)question.choices.get((int)selection.intValue())).value.getValue());
                    }
                    break;
                }
            }
            submittedAnswers.add(preparedAnswer);
        }
        SurveyAnswer surveyAnswer = new SurveyAnswer(this.survey.resultId, submittedAnswers);
        this.progressDialog.show();
        this.surveyViewModel.submitSurveyAnswers(surveyAnswer, this.survey.getContent());
    }

    private void changeState() {
        int position = this.viewPager.getCurrentItem();
        this.btnBack.setVisibility(0);
        this.btnNext.setText(R.string.flybits_con_fragment_survey_next);
        if (position == 0) {
            this.btnBack.setVisibility(8);
        }
        if (position == this.viewPager.getAdapter().getCount() - 1) {
            this.btnNext.setText(R.string.flybits_con_fragment_survey_finish);
        }
    }

    private class SurveyPagerAdapter
    extends FragmentPagerAdapter {
        SurveyPagerAdapter(FragmentManager childFragmentManager) {
            super(childFragmentManager);
        }

        public Fragment getItem(int position) {
            Question question = (Question)((SurveyFragment)SurveyFragment.this).survey.questions.getList().get(position);
            return QuestionFragment.newInstance(question, position + 1);
        }

        public int getCount() {
            return SurveyFragment.this.survey != null ? ((SurveyFragment)SurveyFragment.this).survey.questions.getList().size() : 0;
        }
    }
}

