/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.concierge;

import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.os.Build;
import android.support.annotation.IdRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import androidx.work.Constraints;
import androidx.work.NetworkType;
import androidx.work.OneTimeWorkRequest;
import androidx.work.WorkManager;
import androidx.work.WorkRequest;
import com.flybits.android.kernel.KernelScope;
import com.flybits.android.push.PushManager;
import com.flybits.android.push.PushScope;
import com.flybits.commons.library.SharedElements;
import com.flybits.commons.library.api.FlybitsManager;
import com.flybits.commons.library.api.FlybitsScope;
import com.flybits.commons.library.api.idps.IDP;
import com.flybits.commons.library.api.results.callbacks.BasicResultCallback;
import com.flybits.commons.library.api.results.callbacks.ConnectionResultCallback;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.logging.Logger;
import com.flybits.concierge.AuthenticationStatusListener;
import com.flybits.concierge.ConciergeConfiguration;
import com.flybits.concierge.InternalPreferences;
import com.flybits.concierge.LogOutCallback;
import com.flybits.concierge.OptOutCallback;
import com.flybits.concierge.OptOutListener;
import com.flybits.concierge.activities.ConciergeActivity;
import com.flybits.concierge.activities.ConciergePopupActivity;
import com.flybits.concierge.enums.ShowMode;
import com.flybits.concierge.exception.ConciergeException;
import com.flybits.concierge.exception.ConciergeOptedOutException;
import com.flybits.concierge.exception.ConciergeUninitializedException;
import com.flybits.concierge.services.PreloadingWorker;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class FlybitsConcierge {
    private static FlybitsConcierge INSTANCE;
    private WeakReference<Context> lastProvidedContext;
    private ConciergeConfiguration currentConfig;
    private IDP idp;
    private FlybitsManager flybitsManager;
    private OptOutListener optOutListener;
    private final Set<AuthenticationStatusListener> authenticationStatusListeners = Collections.synchronizedSet(new HashSet());
    private boolean authenticating = false;
    private boolean authenticationRequested = false;
    private boolean networkReceiverRegistered = false;
    private boolean initialized = false;
    private BroadcastReceiver networkReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            try {
                ConnectivityManager manager = (ConnectivityManager)context.getSystemService("connectivity");
                if (manager.getActiveNetworkInfo() != null && manager.getActiveNetworkInfo().isConnected() && FlybitsConcierge.this.isAutoRetryAuthenticationOnConnectedEnabled() && !FlybitsConcierge.this.isAuthenticated() && FlybitsConcierge.this.authenticationRequested) {
                    FlybitsConcierge.this.retryAuthentication();
                }
            }
            catch (Exception e) {
                Logger.exception((String)"networkReceiver.onReceive", (Exception)e);
            }
        }
    };
    private ConnectionResultCallback conciergeConnectionResultCallback = new ConnectionResultCallback(){

        public void onConnected() {
            FlybitsConcierge.this.authenticating = false;
            FlybitsConcierge.this.broadcastAuthenticationState("authenticated");
            FlybitsConcierge.this.unregisterNetworkReceiver();
            FlybitsConcierge.this.schedulerWorkers();
            FlybitsConcierge.this.enablePushMessaging(new BasicResultCallback(){

                public void onSuccess() {
                }

                public void onException(FlybitsException exception) {
                    Logger.exception((String)FlybitsConcierge.class.getSimpleName(), (Exception)((Object)exception));
                }
            });
        }

        public void notConnected() {
            FlybitsConcierge.this.authenticating = false;
        }

        public void onException(FlybitsException exception) {
            FlybitsConcierge.this.authenticating = false;
            Context context = FlybitsConcierge.this.getContext();
            if (context != null && SharedElements.getSavedJWTToken((Context)context).isEmpty()) {
                FlybitsConcierge.this.broadcastAuthenticationError(new ConciergeException(exception.getMessage()));
            } else if (context != null && exception.getMessage().contains("Connecting") && FlybitsConcierge.this.isAuthenticated()) {
                FlybitsConcierge.this.broadcastAuthenticationState("authenticated");
            }
            FlybitsConcierge.this.registerNetworkReceiver();
        }
    };

    private FlybitsConcierge(WeakReference<Context> context) {
        this.lastProvidedContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FlybitsConcierge with(Context context) {
        if (context == null) {
            throw new ConciergeUninitializedException();
        }
        Class<FlybitsConcierge> clazz = FlybitsConcierge.class;
        synchronized (FlybitsConcierge.class) {
            if (INSTANCE == null) {
                INSTANCE = new FlybitsConcierge(new WeakReference<Context>(context.getApplicationContext()));
                INSTANCE.createNotificationChannel();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return INSTANCE;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            FlybitsConcierge.INSTANCE.lastProvidedContext = new WeakReference<Context>(context.getApplicationContext());
            return INSTANCE;
        }
    }

    private void createNotificationChannel() {
        if (Build.VERSION.SDK_INT >= 26) {
            String name = "Concierge Channel";
            String description = "Specific for playing audio content in the concierge.";
            NotificationChannel channel = new NotificationChannel("FLYBITS_CONCIERGE_AUDIO", (CharSequence)name, 4);
            channel.setDescription(description);
            NotificationManager notificationManager = (NotificationManager)this.getContext().getSystemService(NotificationManager.class);
            notificationManager.createNotificationChannel(channel);
        }
    }

    private Context getContext() throws ConciergeException {
        if (this.lastProvidedContext != null && this.lastProvidedContext.get() != null) {
            return (Context)this.lastProvidedContext.get();
        }
        throw new ConciergeException("Context was null");
    }

    private FlybitsManager createFlybitsManager() {
        FlybitsManager.Builder builder = new FlybitsManager.Builder(this.getContext()).setAccount(null).setProjectId(this.getConfiguration().getProjectID()).addScope((FlybitsScope)PushScope.SCOPE).addScope((FlybitsScope)KernelScope.SCOPE);
        return builder.build();
    }

    public boolean initialize(@IdRes int cfgResource) {
        if (this.initialized) {
            return false;
        }
        this.initialize(ConciergeConfiguration.createFromXML(this.getContext(), cfgResource));
        this.initialized = true;
        this.flybitsManager = this.createFlybitsManager();
        return true;
    }

    void initialize(ConciergeConfiguration cfg) {
        this.currentConfig = cfg;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAuthenticationStateListener(@NonNull AuthenticationStatusListener authenticationStatusListener) {
        Set<AuthenticationStatusListener> set = this.authenticationStatusListeners;
        synchronized (set) {
            this.authenticationStatusListeners.add(authenticationStatusListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unregisterAuthenticationStateListener(@NonNull AuthenticationStatusListener authenticationStatusListener) {
        Set<AuthenticationStatusListener> set = this.authenticationStatusListeners;
        synchronized (set) {
            return this.authenticationStatusListeners.remove(authenticationStatusListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void broadcastAuthenticationState(String state) {
        Set<AuthenticationStatusListener> set = this.authenticationStatusListeners;
        synchronized (set) {
            Object[] copy;
            block11: for (Object o : copy = this.authenticationStatusListeners.toArray()) {
                AuthenticationStatusListener authenticationStatusListener = (AuthenticationStatusListener)o;
                switch (state) {
                    case "authenticated": {
                        authenticationStatusListener.onAuthenticated();
                        continue block11;
                    }
                    case "authentication_started": {
                        authenticationStatusListener.onAuthenticationStarted();
                        continue block11;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void broadcastAuthenticationError(ConciergeException err) {
        Set<AuthenticationStatusListener> set = this.authenticationStatusListeners;
        synchronized (set) {
            Object[] copy;
            for (Object o : copy = this.authenticationStatusListeners.toArray()) {
                AuthenticationStatusListener authenticationStatusListener = (AuthenticationStatusListener)o;
                authenticationStatusListener.onError(err);
            }
        }
    }

    synchronized boolean retryAuthentication() {
        if (!this.isInitialized()) {
            throw new ConciergeUninitializedException();
        }
        if (this.idp == null || this.authenticating || this.isAuthenticated() || !this.authenticationRequested) {
            return false;
        }
        this.authenticate(this.idp);
        return true;
    }

    public synchronized boolean authenticate(@NonNull IDP idp) {
        Context context = this.getContext();
        if (!this.isInitialized()) {
            throw new ConciergeUninitializedException();
        }
        InternalPreferences.setOptOutState(context, false);
        if (this.isAuthenticated() || this.authenticating) {
            return false;
        }
        this.authenticating = true;
        if (this.flybitsManager == null) {
            this.flybitsManager = this.createFlybitsManager();
        }
        this.idp = idp;
        this.broadcastAuthenticationState("authentication_started");
        this.authenticationRequested = true;
        this.flybitsManager.connect(idp, this.conciergeConnectionResultCallback);
        return true;
    }

    public void logOut(final LogOutCallback logOutCallback) {
        if (!this.isInitialized()) {
            throw new ConciergeUninitializedException();
        }
        if (!this.isAuthenticated() || this.authenticating || this.flybitsManager == null) {
            logOutCallback.onError(new ConciergeException("Authentication required before logging out"));
        } else {
            this.flybitsManager.disconnect(new BasicResultCallback(){

                public void onSuccess() {
                    FlybitsConcierge.this.authenticationRequested = false;
                    FlybitsConcierge.this.unregisterNetworkReceiver();
                    if (logOutCallback != null) {
                        logOutCallback.onSuccess();
                    }
                }

                public void onException(FlybitsException exception) {
                    if (logOutCallback != null) {
                        logOutCallback.onError(new ConciergeException(exception));
                    }
                }
            });
        }
    }

    public void setOptOutListener(@NonNull OptOutListener optOutListener) {
        this.optOutListener = optOutListener;
    }

    public void clearOptOutListener() {
        this.optOutListener = null;
    }

    public boolean isOptedOut() {
        if (this.isInitialized()) {
            return InternalPreferences.getOptOutState(this.getContext());
        }
        throw new ConciergeUninitializedException();
    }

    public void optOut(final @Nullable OptOutCallback callback) {
        if (!this.isInitialized()) {
            throw new ConciergeUninitializedException();
        }
        if (this.isOptedOut()) {
            throw new ConciergeOptedOutException();
        }
        if (!this.isAuthenticated() || this.authenticating || this.flybitsManager == null) {
            callback.onError(new ConciergeException("Authentication required."));
            return;
        }
        final Context context = this.getContext();
        this.flybitsManager.destroy(new BasicResultCallback(){

            public void onSuccess() {
                InternalPreferences.saveTNCAccepted(context, false);
                InternalPreferences.setOptOutState(context, true);
                FlybitsConcierge.this.authenticating = false;
                FlybitsConcierge.this.unregisterNetworkReceiver();
                FlybitsConcierge.this.authenticationRequested = false;
                if (FlybitsConcierge.this.optOutListener != null) {
                    FlybitsConcierge.this.optOutListener.onUserOptedOut();
                }
                if (callback != null) {
                    callback.onSuccess();
                }
                FlybitsConcierge.this.flybitsManager = null;
            }

            public void onException(FlybitsException exception) {
                if (callback != null) {
                    callback.onError(new ConciergeException(exception));
                }
            }
        });
    }

    private boolean unregisterNetworkReceiver() {
        if (this.networkReceiverRegistered) {
            try {
                this.getContext().unregisterReceiver(this.networkReceiver);
                this.networkReceiverRegistered = false;
                return true;
            }
            catch (Exception e) {
                Logger.exception((String)"FlybitsConcierge.unregisterNetworkReceiver()", (Exception)e);
                return false;
            }
        }
        return false;
    }

    private boolean registerNetworkReceiver() {
        if (!this.networkReceiverRegistered && this.isAutoRetryAuthenticationOnConnectedEnabled()) {
            IntentFilter intentFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
            try {
                this.getContext().registerReceiver(this.networkReceiver, intentFilter);
                this.networkReceiverRegistered = true;
                return true;
            }
            catch (Exception e) {
                Logger.exception((String)"FlybitsConcierge.registerNetworkReceiver()", (Exception)e);
                return false;
            }
        }
        return false;
    }

    public void show(ShowMode mode) throws ConciergeException {
        Context context = this.getContext();
        if (!this.isInitialized()) {
            throw new ConciergeUninitializedException();
        }
        if (InternalPreferences.getOptOutState(context)) {
            throw new ConciergeOptedOutException();
        }
        Intent activityIntent = null;
        switch (mode) {
            case NEW_ACTIVITY: {
                activityIntent = new Intent(context, ConciergeActivity.class);
                break;
            }
            case OVERLAY: {
                activityIntent = new Intent(context, ConciergePopupActivity.class);
            }
        }
        activityIntent.setFlags(0x10000000);
        context.startActivity(activityIntent);
    }

    public void setAutoRetryAuthenticationOnConnected(boolean enabled) {
        Context context = this.getContext();
        if (!this.isInitialized()) {
            throw new ConciergeUninitializedException();
        }
        InternalPreferences.setAutoRetryAuthOnConnected(context, enabled);
    }

    public boolean isAutoRetryAuthenticationOnConnectedEnabled() {
        Context context = this.getContext();
        if (this.isInitialized()) {
            return InternalPreferences.isAutoRetryAuthOnConnectedEnabled(context);
        }
        throw new ConciergeUninitializedException();
    }

    public ConciergeConfiguration getConfiguration() {
        if (!this.isInitialized()) {
            throw new ConciergeUninitializedException();
        }
        return this.currentConfig;
    }

    private void enablePushMessaging(BasicResultCallback callback) {
        String token = InternalPreferences.pushToken(this.getContext());
        if (token == null) {
            return;
        }
        PushManager.enablePush((Context)this.getContext(), (String)token, new HashMap(), (BasicResultCallback)callback);
    }

    public boolean isAuthenticated() {
        Context context = this.getContext();
        if (this.isInitialized()) {
            return !SharedElements.getSavedJWTToken((Context)context).isEmpty();
        }
        throw new ConciergeUninitializedException();
    }

    public boolean isAuthenticating() {
        if (this.isInitialized()) {
            return this.authenticating;
        }
        throw new ConciergeUninitializedException();
    }

    private void schedulerWorkers() {
        WorkManager workManager = WorkManager.getInstance();
        Constraints workConstraints = new Constraints.Builder().setRequiredNetworkType(NetworkType.CONNECTED).build();
        WorkRequest workRequest = ((OneTimeWorkRequest.Builder)new OneTimeWorkRequest.Builder(PreloadingWorker.class).setConstraints(workConstraints)).build();
        workManager.enqueue(new WorkRequest[]{workRequest});
    }
}

