package com.flybits.concierge.viewholders;

import android.support.v4.content.ContextCompat;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

import com.flybits.concierge.ConciergeFragment;
import com.flybits.concierge.R;
import com.flybits.concierge.fragments.VideoPlaylistFragment;
import com.flybits.concierge.models.Video;
import com.flybits.concierge.models.Videos;

import java.util.ArrayList;

public class VideosViewHolder extends BaseViewHolder<Videos>
{
    private ConciergeFragment conciergeFragment;
    private View thisView;
    private ImageView[] singlePlaceHolderViews;
    private ImageView[] doublePlaceHolderViews;
    private ImageView[] triplePlaceHolderViews;
    private View tripleContainer;
    private View doubleContainer;
    private View singleContainer;
    private View callToActionView;

    public VideosViewHolder(ConciergeFragment conFrag, View view)
    {
        super(conFrag, view);
        this.thisView = view;
        conciergeFragment = conFrag;

        triplePlaceHolderViews = new ImageView[] {
                view.findViewById(R.id.flybits_con_item_template_videos_imgBig),
                view.findViewById(R.id.flybits_con_item_template_videos_imgTR),
                view.findViewById(R.id.flybits_con_item_template_videos_imgBR)
        };

        doublePlaceHolderViews = new ImageView[] {
                view.findViewById(R.id.flybits_con_item_template_videos_imgLeft),
                view.findViewById(R.id.flybits_con_item_template_videos_imgRight)
        };

        singlePlaceHolderViews = new ImageView[] {
                view.findViewById(R.id.flybits_con_item_template_videos_single),
        };

        tripleContainer = view.findViewById(R.id.flybits_con_item_template_videos_triple);
        doubleContainer = view.findViewById(R.id.flybits_con_item_template_videos_double);
        singleContainer = view.findViewById(R.id.flybits_con_item_template_videos_single_container);
        callToActionView = view.findViewById(R.id.flybits_con_item_template_videos_callToAction);
    }

    @Override
    public void bindData(Videos data)
    {
        final ArrayList<Video> videos = data.videos.getList();

        tripleContainer.setVisibility(videos.size() > 2 ? View.VISIBLE : View.GONE);
        doubleContainer.setVisibility(videos.size() == 2 ? View.VISIBLE : View.GONE);
        singleContainer.setVisibility(videos.size() == 1 ? View.VISIBLE : View.GONE);
        callToActionView.setVisibility(videos.size() > 1 ? View.VISIBLE : View.GONE);

        ImageView[] placeHolderViews;

        switch (videos.size())
        {
            case 0:
                return;
            case 1:
                TextView titleTextView = thisView.findViewById(R.id.flybits_con_item_template_videos_txtTitle);
                TextView durationTextView = thisView.findViewById(R.id.flybits_con_item_template_videos_txtDuration);
                videos.get(0).populateViews(conciergeFragment, titleTextView, durationTextView, singlePlaceHolderViews[0], thisView);
                return;
            case 2:
                placeHolderViews = doublePlaceHolderViews;
                break;
            default:
                placeHolderViews = triplePlaceHolderViews;
        }

        for (int i = 0; i < placeHolderViews.length; i++)
        {
            final ImageView view = placeHolderViews[i];
            if (i < videos.size())
            {
                final Video video = videos.get(i);

                video.populateViews(conciergeFragment, view, view);
            }
            else
            {
                view.setImageDrawable(ContextCompat.getDrawable(view.getContext(), android.R.drawable.bottom_bar));
                view.setOnClickListener(null);
            }
        }

        callToActionView.setOnClickListener(new View.OnClickListener()
        {
            @Override
            public void onClick(View v)
            {
                VideoPlaylistFragment fragment = VideoPlaylistFragment.newInstance(videos);
                conciergeFragment.openFragment(fragment);
            }
        });
    }
}
