package com.flybits.concierge.viewholders;

import android.view.View;
import android.widget.TextView;

import com.flybits.android.kernel.reservedtemplates.survey.models.Question;
import com.flybits.concierge.ConciergeFragment;
import com.flybits.concierge.R;
import com.flybits.concierge.fragments.SurveyFragment;
import com.flybits.concierge.models.Survey;

import java.util.Locale;

public class SurveyViewHolder extends BaseViewHolder<Survey>
{
    private final TextView titleTextView;
    private View thisView;
    private ConciergeFragment conciergeFragment;

    public SurveyViewHolder(ConciergeFragment conFrag, View itemView)
    {
        super(conFrag, itemView);
        thisView = itemView;
        titleTextView = itemView.findViewById(R.id.flybits_con_item_survey_txtTitle);
        conciergeFragment = conFrag;
    }

    @Override
    public void bindData(final Survey data)
    {
        for (Question question : data.questions.getList())
        {
            titleTextView.setText(String.format(Locale.getDefault(), "Survey - %s", question.question.getValue()));
            break;
        }

        thisView.setOnClickListener(new View.OnClickListener()
        {
            @Override
            public void onClick(View v)
            {
                SurveyFragment fragment = SurveyFragment.newInstance(data);
                conciergeFragment.openFragment(fragment);
            }
        });
    }
}
