package com.flybits.concierge.viewholders;

import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

import com.flybits.concierge.ConciergeFragment;
import com.flybits.concierge.R;
import com.flybits.concierge.fragments.ScheduleSegmentFragment;
import com.flybits.concierge.models.ScheduleSegment;

public class ScheduleSegmentViewHolder extends BaseViewHolder<ScheduleSegment>
{
    private final TextView timeRangeView;
    private final TextView titleView;
    private final View clickableArea;
    private final ConciergeFragment conciergeFragment;
    private final View ruleView;
    private final TextView descriptionView;
    private final ImageView bulletOutView;
    private final ImageView bulletInView;

    public ScheduleSegmentViewHolder(ConciergeFragment conciergeFragment, View itemView)
    {
        super(conciergeFragment, itemView);

        this.conciergeFragment = conciergeFragment;
        clickableArea = itemView.findViewById(R.id.flybits_con_item_template_schedule_segment_lytContainer);
        timeRangeView = itemView.findViewById(R.id.flybits_con_item_template_schedule_segment_txtTimeRange);
        titleView = itemView.findViewById(R.id.flybits_con_item_template_schedule_segment_txtTitle);
        descriptionView = itemView.findViewById(R.id.flybits_con_item_template_schedule_segment_txtDescription);
        ruleView =  itemView.findViewById(R.id.flybits_con_item_template_schedule_segment_viewRuleBottom);
        bulletOutView = itemView.findViewById(R.id.flybits_con_item_template_schedule_segment_imgBulletOut);
        bulletInView = itemView.findViewById(R.id.flybits_con_item_template_schedule_segment_imgBulletIn);
    }

    @Override
    public void bindData(final ScheduleSegment data)
    {
        clickableArea.setOnClickListener(new View.OnClickListener()
        {
            @Override
            public void onClick(View v)
            {
                ScheduleSegmentFragment fragment = ScheduleSegmentFragment.newInstance(data);
                conciergeFragment.openFragment(fragment);
            }
        });

        data.populateViews(timeRangeView, titleView, descriptionView, bulletOutView, bulletInView, clickableArea);
    }

    public void setLast(boolean last)
    {
        ruleView.setVisibility(last ? View.INVISIBLE : View.VISIBLE);
    }
}
