package com.flybits.concierge.viewholders;

import android.media.session.PlaybackState;
import android.support.v4.media.session.MediaControllerCompat;
import android.support.v4.media.session.PlaybackStateCompat;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.flybits.commons.library.logging.Logger;
import com.flybits.concierge.ConciergeFragment;
import com.flybits.concierge.R;
import com.flybits.concierge.models.Audio;
import com.flybits.concierge.models.Audios;
import com.flybits.concierge.services.AudioService;

import java.util.List;

public class AudiosViewHolder extends BaseViewHolder<Audios>
{

    private ConciergeFragment conciergeFragment;
    private LinearLayout thisView;

    public AudiosViewHolder(ConciergeFragment conFrag, View itemView)
    {
        super(conFrag, itemView);

        this.conciergeFragment = conFrag;
        this.thisView = (LinearLayout) itemView;
    }

    @Override
    public void bindData(final Audios data)
    {
        super.bindData(data);

        List<Audio> audioList = data.audios.getList();

        thisView.removeAllViews();

        for (final Audio audio : audioList)
        {
            View view = LayoutInflater.from(thisView.getContext()).inflate(R.layout.flybits_con_item_template_audio, thisView, false);

            ImageView imgImage = view.findViewById(R.id.flybits_con_audio_imgImage);
            final ImageView imgMediaStatusPlayPause = view.findViewById(R.id.flybits_con_audio_imgMediaStatusPlayPause);
            final ImageView imgMediaStatusStop = view.findViewById(R.id.flybits_con_audio_imgMediaStatusStop);
            TextView txtTitle = view.findViewById(R.id.flybits_con_audio_txtTitle);
            TextView txtDescription = view.findViewById(R.id.flybits_con_audio_txtDescription);
            TextView txtDuration = view.findViewById(R.id.flybits_con_audio_txtDuration);

            // populate views
            audio.populateViews(txtTitle, txtDescription, txtDuration, imgImage);

            String playingURL = conciergeFragment.getCurrentAudio() != null && conciergeFragment.getCurrentAudio().sourceURL != null ? conciergeFragment.getCurrentAudio().sourceURL : AudioService.getPlayingURL();
            int playingState = AudioService.getPlayingState();

            if (playingURL != null && playingURL.contentEquals(audio.sourceURL))
            {
                if (playingState == PlaybackState.STATE_NONE || playingState == PlaybackState.STATE_STOPPED)
                {
                    imgMediaStatusPlayPause.setImageResource(R.drawable.ic_baseline_play_arrow_24px);
                }
                else if (playingState == PlaybackState.STATE_PAUSED)
                {
                    imgMediaStatusPlayPause.setImageResource(R.drawable.ic_baseline_play_arrow_24px);
                }
                else if (playingState == PlaybackState.STATE_PLAYING)
                {
                    imgMediaStatusStop.setVisibility(View.VISIBLE);
                    imgMediaStatusPlayPause.setImageResource(R.drawable.ic_baseline_pause_24px);
                }
            }

            conciergeFragment.registerMediaControllerCallback(new MediaControllerCompat.Callback() {
                @Override
                public void onPlaybackStateChanged(PlaybackStateCompat state) {
                    super.onPlaybackStateChanged(state);
                    try{
                        switch(state.getState()){
                            case PlaybackState.STATE_NONE:
                                imgMediaStatusPlayPause.setImageResource(R.drawable.ic_baseline_play_arrow_24px);
                                break;
                            case PlaybackState.STATE_STOPPED:
                                imgMediaStatusPlayPause.setImageResource(R.drawable.ic_baseline_play_arrow_24px);
                                break;
                            case PlaybackState.STATE_PLAYING:
                                imgMediaStatusPlayPause.setImageResource(R.drawable.ic_baseline_pause_24px);
                                break;
                            case PlaybackState.STATE_PAUSED:
                                imgMediaStatusPlayPause.setImageResource(R.drawable.ic_baseline_play_arrow_24px);
                                break;
                        }
                    }catch(Exception e){
                        Logger.exception("AudiosViewHolder.bindData()",e);
                    }

                }
            });

            imgMediaStatusPlayPause.setOnClickListener(new View.OnClickListener()
            {
                @Override
                public void onClick(final View view)
                {
                    if (conciergeFragment.getCurrentAudio() != null && conciergeFragment.getCurrentAudio().sourceURL != null && conciergeFragment.getCurrentAudio().sourceURL.equals(audio.sourceURL) && conciergeFragment.getAudioState() == PlaybackState.STATE_PLAYING)
                    {
                        conciergeFragment.pauseAudio();
                    }
                    else if (conciergeFragment.getCurrentAudio() != null && conciergeFragment.getCurrentAudio().sourceURL != null && conciergeFragment.getCurrentAudio().sourceURL.equals(audio.sourceURL) && conciergeFragment.getAudioState() == PlaybackState.STATE_PAUSED)
                    {
                        conciergeFragment.resumeAudio();
                    }
                    else if (conciergeFragment.getAudioState() == PlaybackState.STATE_NONE || conciergeFragment.getAudioState() == PlaybackState.STATE_STOPPED)
                    {
                        conciergeFragment.startAudio(audio);
                    }
                }
            });

            imgMediaStatusStop.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    conciergeFragment.stopAudio();
                }
            });




            thisView.addView(view);
        }
    }
}
