package com.flybits.concierge.models;

import android.content.Context;
import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

import com.bumptech.glide.Glide;
import com.bumptech.glide.load.DecodeFormat;
import com.bumptech.glide.request.RequestOptions;
import com.flybits.android.kernel.models.PagedArray;
import com.flybits.commons.library.logging.Logger;
import com.flybits.concierge.ConciergeFragment;
import com.flybits.concierge.Utils;
import com.flybits.concierge.activities.YouTubePlayerActivity;
import com.flybits.concierge.enums.FeedView;
import com.flybits.concierge.fragments.VideoFragment;

import java.net.URL;
import java.util.Map;

public class Videos extends BaseTemplate implements Parcelable
{
    public Videos()
    {
    }
    public PagedArray<Video> videos;

    public static final Creator<Videos> CREATOR = new Creator<Videos>()
    {
        @Override
        public Videos createFromParcel(Parcel in)
        {
            return new Videos(in);
        }

        @Override
        public Videos[] newArray(int size)
        {
            return new Videos[size];
        }
    };

    public Videos(Parcel in)
    {
        videos = in.readParcelable(PagedArray.class.getClassLoader());
    }

    @Override
    public FeedView getType()
    {
        return FeedView.VIDEOS;
    }

    @Override
    public int describeContents()
    {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags)
    {
        dest.writeParcelable(videos, flags);
    }
}
