package com.flybits.concierge.models;

import android.content.Context;
import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

import com.bumptech.glide.Glide;
import com.bumptech.glide.load.DecodeFormat;
import com.bumptech.glide.request.RequestOptions;
import com.flybits.android.kernel.models.LocalizedValue;
import com.flybits.commons.library.logging.Logger;
import com.flybits.concierge.ConciergeFragment;
import com.flybits.concierge.Utils;
import com.flybits.concierge.activities.YouTubePlayerActivity;
import com.flybits.concierge.enums.FeedView;
import com.flybits.concierge.fragments.VideoFragment;

import java.net.URL;
import java.util.Map;

public class Video extends BaseTemplate implements Parcelable
{
    public Video()
    {
    }

    public LocalizedValue title;
    public String url;
    public String duration;
    public String imageURL;

    protected Video(Parcel in)
    {
        title = in.readParcelable(LocalizedValue.class.getClassLoader());
        url = in.readString();
        duration = in.readString();
        imageURL = in.readString();
    }

    public static final Creator<Video> CREATOR = new Creator<Video>()
    {
        @Override
        public Video createFromParcel(Parcel in)
        {
            return new Video(in);
        }

        @Override
        public Video[] newArray(int size)
        {
            return new Video[size];
        }
    };

    @Override
    public FeedView getType()
    {
        return FeedView.VIDEO;
    }

    @Override
    public int describeContents()
    {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags)
    {
        dest.writeParcelable(title, flags);
        dest.writeString(url);
        dest.writeString(duration);
        dest.writeString(imageURL);
    }

    public void populateViews(ConciergeFragment conciergeFragment, ImageView placeholderImageView, View callToActionView)
    {
        populateViews(conciergeFragment, null, null, placeholderImageView, callToActionView);
    }

    public void populateViews(final ConciergeFragment conciergeFragment, TextView titleTextView, TextView durationTextView, ImageView placeholderImageView, View callToActionView)
    {
        if (titleTextView != null)
        {
            titleTextView.setText(title.getValue());
        }

        if (durationTextView != null)
        {
            durationTextView.setVisibility(!TextUtils.isEmpty(duration) ? View.VISIBLE : View.INVISIBLE);
            durationTextView.setText(duration);
        }

        RequestOptions options = new RequestOptions().format(DecodeFormat.PREFER_RGB_565);

        Glide.with(placeholderImageView.getContext())
                .load(imageURL)
                .apply(options)
                .into(placeholderImageView);

        callToActionView.setOnClickListener(new View.OnClickListener()
        {
            @Override
            public void onClick(View v)
            {
                // YouTube
                try
                {
                    URL videoUrl = new URL(url);
                    videoUrl.getHost();

                    String videoId = null;

                    switch (videoUrl.getHost())
                    {
                        case "www.youtube.com":
                            Map<String, String> map = Utils.splitQuery(videoUrl);
                            videoId = map.get("v");
                            break;
                        case "youtu.be":
                            String path = videoUrl.getPath();
                            if (!TextUtils.isEmpty(path) && path.length() > 2)
                            {
                                videoId = videoUrl.getPath()
                                        .substring(1);
                            }
                            break;
                    }

                    if (!TextUtils.isEmpty(videoId))
                    {
                        watchYoutubeVideo(v.getContext(), videoId);
                        return;
                    }
                }
                catch (Exception e)
                {
                    Logger.exception(Video.class.getSimpleName(), e);
                }

                // Server
                VideoFragment fragment = VideoFragment.newInstance(Video.this);
                conciergeFragment.openFragment(fragment);
            }
        });
    }

    private void watchYoutubeVideo(Context context, String id)
    {
        Intent intent = new Intent(context, YouTubePlayerActivity.class);
        intent.putExtra(YouTubePlayerActivity.ARG_ID_KEY, id);
        context.startActivity(intent);
    }
}
