package com.flybits.concierge.models;

import android.os.Parcel;
import android.os.Parcelable;

import com.flybits.android.kernel.models.LocalizedValue;
import com.flybits.concierge.enums.FeedView;

public class Text extends BaseTemplate implements Parcelable
{
    public LocalizedValue header;
    public LocalizedValue description;

    public Text() {
    }

    protected Text(Parcel in)
    {
        header = in.readParcelable(LocalizedValue.class.getClassLoader());
        description = in.readParcelable(LocalizedValue.class.getClassLoader());
    }

    @Override
    public FeedView getType() {
        return FeedView.TEXT;
    }

    public static final Creator<Text> CREATOR = new Creator<Text>()
    {
        @Override
        public Text createFromParcel(Parcel in)
        {
            return new Text(in);
        }

        @Override
        public Text[] newArray(int size)
        {
            return new Text[size];
        }
    };

    @Override
    public int describeContents()
    {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags)
    {
        dest.writeParcelable(header, 0);
        dest.writeParcelable(description, 0);
    }
}
