package com.flybits.concierge.fragments;

import android.app.Activity;
import android.arch.lifecycle.ViewModelProvider;
import android.arch.lifecycle.ViewModelProviders;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Switch;
import android.widget.Toast;

import com.afollestad.materialdialogs.DialogAction;
import com.afollestad.materialdialogs.MaterialDialog;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.logging.Logger;
import com.flybits.concierge.FlybitsConcierge;
import com.flybits.concierge.OptOutCallback;
import com.flybits.concierge.R;
import com.flybits.concierge.activities.SettingsActivity;
import com.flybits.concierge.exception.ConciergeException;
import com.flybits.concierge.viewmodels.SettingsViewModel;

public class SettingsFragment extends Fragment {

    private Switch optSwitch;
    private View termsOfService;
    private View privacyPolicy;
    private MaterialDialog optOutDialog;
    private SettingsViewModel viewModel;

    public static SettingsFragment newInstance(){
        return new SettingsFragment();
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.flybits_con_fragment_settings,container,false);
        return view;
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);

        viewModel = ViewModelProviders.of(this).get(SettingsViewModel.class);

        optSwitch = view.findViewById(R.id.flybits_con_settings_opt_switch);
        termsOfService = view.findViewById(R.id.flybits_con_settings_terms_of_service_text);
        privacyPolicy = view.findViewById(R.id.flybits_con_settings_privacy_policy_text);

        Context context = getContext();
        if (context != null && optOutDialog == null)
            optOutDialog = new MaterialDialog.Builder(context).title(R.string.flybits_con_opt_out)
                    .positiveText(R.string.flybits_con_yes)
                    .negativeText(R.string.flybits_con_no)
                    .content(R.string.flybits_con_opt_out_warning)
                    .onPositive(new MaterialDialog.SingleButtonCallback() {
                        @Override
                        public void onClick(@NonNull MaterialDialog dialog, @NonNull DialogAction which) {
                            Activity activity = getActivity();
                            if (activity != null && activity instanceof SettingsActivity){
                                viewModel.optOutFlybits(new OptOutCallback() {
                                    @Override
                                    public void onSuccess() {
                                        Activity settingsActivity = getActivity();
                                        if (settingsActivity instanceof SettingsActivity){
                                            ((SettingsActivity)settingsActivity).optOutOfFlybits();
                                        }
                                    }

                                    @Override
                                    public void onError(ConciergeException e) {
                                        Activity settingsActivity = getActivity();
                                        //Make sure user didn't exit settings
                                        if (settingsActivity instanceof SettingsActivity){
                                            Toast.makeText(settingsActivity,"Please connect to the internet to opt out.",Toast.LENGTH_LONG).show();
                                        }
                                    }
                                });
                            }
                        }
                    })
                    .dismissListener(new DialogInterface.OnDismissListener() {
                        @Override
                        public void onDismiss(DialogInterface dialogInterface) {
                            if (optSwitch != null){
                                optSwitch.setChecked(false);
                            }
                        }
                    })
                    .build();

        optSwitch.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                if (optSwitch.isChecked()){
                    displayOptOutDialog();
                }
            }
        });

        termsOfService.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                Activity activity = getActivity();
                if (activity != null && activity instanceof SettingsActivity){
                    ((SettingsActivity)activity).switchToTermsOfService();
                }
            }
        });

        privacyPolicy.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                Activity activity = getActivity();
                if (activity != null && activity instanceof SettingsActivity){
                    ((SettingsActivity)activity).switchToPrivacyPolicy();
                }

            }
        });
    }

    private void displayOptOutDialog(){
        Context context = getContext();
        if (context != null){
            optOutDialog.show();
        }
    }

    @Override
    public void onStop() {
        if (optOutDialog != null)
            optOutDialog.dismiss();
        super.onStop();
    }

    @Override
    public void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        if (optOutDialog != null){
            outState.putAll(optOutDialog.onSaveInstanceState());
        }
    }

    @Override
    public void onViewStateRestored(@Nullable Bundle savedInstanceState) {
        super.onViewStateRestored(savedInstanceState);
        if (optOutDialog != null && savedInstanceState != null){
            optOutDialog.onRestoreInstanceState(savedInstanceState);
        }
    }

}
