package com.flybits.concierge;

import android.content.Context;
import android.content.SharedPreferences;

public class InternalPreferences
{

    protected final static String PREFS_NAME = "ConciergePrefs";
    protected final static String TNC_ACCEPTED = "tnc_accepted";
    protected final static String FB_PUSH_TOKEN = "fire_base_push_token";
    protected final static String ONBOARDING_DONE = "onboarded";
    protected final static String AUTO_AUTH_ON_CONNECT = "auto_authenticate";
    protected final static String IS_OPTED_OUT = "ctn_flybits_opted_out";

    private static SharedPreferences getInstance(Context context)
    {
        return context.getSharedPreferences(PREFS_NAME, Context.MODE_PRIVATE);
    }

    public static void saveTNCAccepted(Context currentContext, boolean value)
    {
        currentContext.getSharedPreferences(PREFS_NAME, Context.MODE_PRIVATE).edit().putBoolean(TNC_ACCEPTED, value).apply();
    }

    private static SharedPreferences.Editor getSaveInstance(Context context)
    {
        return getInstance(context).edit();
    }

    public static boolean isTNCAccepted(Context context)
    {
        return getInstance(context).getBoolean(TNC_ACCEPTED, false);
    }

    public static void setAutoRetryAuthOnConnected(Context currentContext, boolean value)
    {
        getSaveInstance(currentContext).putBoolean(AUTO_AUTH_ON_CONNECT, value).apply();
    }

    public static boolean isAutoRetryAuthOnConnectedEnabled(Context currentContext)
    {
        //This option is true by default
        return getInstance(currentContext).getBoolean(AUTO_AUTH_ON_CONNECT, true);
    }

    public static void setOptOutState(Context currentContext, boolean value)
    {
        getSaveInstance(currentContext).putBoolean(IS_OPTED_OUT,value).apply();
    }

    public static boolean getOptOutState(Context currentContext)
    {
        return getInstance(currentContext).getBoolean(IS_OPTED_OUT,false);
    }

    public static boolean isOnBoardingDone(Context context)
    {
        return getInstance(context).getBoolean(ONBOARDING_DONE, false);
    }

    public static void saveOnBoardingDone(Context currentContext, boolean value)
    {
        getSaveInstance(currentContext)
                .putBoolean(ONBOARDING_DONE, value)
                .apply();
    }

    public static void savePushToken(Context currentContext, String value)
    {
        getSaveInstance(currentContext)
                .putString(FB_PUSH_TOKEN, value)
                .apply();
    }

    public static String pushToken(Context currentContext)
    {
        return getInstance(currentContext).getString(FB_PUSH_TOKEN, null);
    }
}
