package com.flybits.concierge;

import android.content.Context;
import android.util.Log;

import com.flybits.android.kernel.models.Content;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.logging.Logger;
import com.flybits.concierge.models.Answer;
import com.flybits.concierge.models.Article;
import com.flybits.concierge.models.Articles;
import com.flybits.concierge.models.Audio;
import com.flybits.concierge.models.Audios;
import com.flybits.concierge.models.BaseTemplate;
import com.flybits.concierge.models.Event;
import com.flybits.concierge.models.Events;
import com.flybits.concierge.models.Image;
import com.flybits.concierge.models.Images;
import com.flybits.concierge.models.Link;
import com.flybits.concierge.models.Links;
import com.flybits.concierge.models.Onboarding;
import com.flybits.concierge.models.Result;
import com.flybits.concierge.models.Schedule;
import com.flybits.concierge.models.Survey;
import com.flybits.concierge.models.Text;
import com.flybits.concierge.models.Twitter;
import com.flybits.concierge.models.Twitters;
import com.flybits.concierge.models.Video;
import com.flybits.concierge.models.Videos;
import com.flybits.concierge.viewmodels.FeedViewModel;

import java.util.Locale;

public class ContentHelper
{
    public static BaseTemplate contentToBaseTemplate(Content content, Context context)
    {
        Class typeClass = null;

        switch (content.getType())
        {
            case ConciergeConstants.ANSWER_CONTENT_TYPE:
                typeClass = Answer.class;
                break;
            case ConciergeConstants.ARTICLE_CONTENT_TYPE:
                typeClass = Articles.class;
                break;
            case ConciergeConstants.EVENT_CONTENT_TYPE:
                typeClass = Events.class;
                break;
            case ConciergeConstants.IMAGE_CONTENT_TYPE:
                typeClass = Images.class;
                break;
            case ConciergeConstants.LINK_CONTENT_TYPE:
                typeClass = Links.class;
                break;
            case ConciergeConstants.ONBOARDING_CONTENT_TYPE:
                typeClass = Onboarding.class;
                break;
            case ConciergeConstants.RESULT_CONTENT_TYPE:
                typeClass = Result.class;
                break;
            case ConciergeConstants.SCHEDULE_CONTENT_TYPE:
                typeClass = Schedule.class;
                break;
            case ConciergeConstants.SURVEY_CONTENT_TYPE:
                typeClass = Survey.class;
                break;
            case ConciergeConstants.TEXT_CONTENT_TYPE:
                typeClass = Text.class;
                break;
            case ConciergeConstants.TWITTER_CONTENT_TYPE:
                typeClass = Twitters.class;
                break;
            case ConciergeConstants.AUDIO_CONTENT_TYPE:
                typeClass = Audios.class;
                break;
            case ConciergeConstants.VIDEO_CONTENT_TYPE:
                typeClass = Videos.class;
                break;
            default:
                Log.d(ContentHelper.class.getSimpleName(), String.format(Locale.getDefault(), "Developer: Invalid Template Found: %s", content.getType()));
        }

        try
        {
            BaseTemplate contentObject = content.getData(context, typeClass);
            contentObject.setContent(content);

            return contentObject;
        }
        catch (FlybitsException e)
        {
            Logger.d(String.format(Locale.getDefault(), "Developer: Invalid Template Found: %s", content.getType()));
            Logger.exception(FeedViewModel.class.getSimpleName(), e);
        }

        return null;
    }
}
