/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.api.results;

import com.flybits.commons.library.api.results.QueryStatus;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0016\u0018\u0000 *2\u00020\u0001:\u0001*B#\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010 \u001a\u00020!J\b\u0010\"\u001a\u00020!H\u0002J\b\u0010#\u001a\u00020!H\u0002J\u000e\u0010$\u001a\u00020!2\u0006\u0010%\u001a\u00020\nJ\u0006\u0010&\u001a\u00020'J\u0006\u0010(\u001a\u00020'J\u0010\u0010)\u001a\u00020!2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006+"}, d2={"Lcom/flybits/commons/library/api/results/FlybitsResult;", "", "serviceExecutor", "Ljava/util/concurrent/ExecutorService;", "time", "", "unit", "Ljava/util/concurrent/TimeUnit;", "(Ljava/util/concurrent/ExecutorService;JLjava/util/concurrent/TimeUnit;)V", "r", "Ljava/lang/Runnable;", "scheduledServiceResult", "Ljava/util/concurrent/ScheduledFuture;", "getScheduledServiceResult", "()Ljava/util/concurrent/ScheduledFuture;", "setScheduledServiceResult", "(Ljava/util/concurrent/ScheduledFuture;)V", "getServiceExecutor", "()Ljava/util/concurrent/ExecutorService;", "serviceTimeout", "Ljava/util/concurrent/ScheduledExecutorService;", "getServiceTimeout", "()Ljava/util/concurrent/ScheduledExecutorService;", "status", "Lcom/flybits/commons/library/api/results/QueryStatus;", "getStatus", "()Lcom/flybits/commons/library/api/results/QueryStatus;", "setStatus", "(Lcom/flybits/commons/library/api/results/QueryStatus;)V", "timeInSeconds", "getTimeInSeconds", "()J", "cancel", "", "cancelRequest", "cancelTimeout", "execute", "runnable", "failed", "", "success", "updateStatus", "Companion", "commons_release"})
public class FlybitsResult {
    @NotNull
    private QueryStatus status;
    private final long timeInSeconds;
    @NotNull
    private final ScheduledExecutorService serviceTimeout;
    @Nullable
    private ScheduledFuture<?> scheduledServiceResult;
    private final Runnable r;
    @NotNull
    private final ExecutorService serviceExecutor;
    private static final long DEFAULT_TIMEOUT = 30L;
    private static final TimeUnit DEFAULT_TIMEOUT_UNIT;
    public static final Companion Companion;

    @NotNull
    public final QueryStatus getStatus() {
        return this.status;
    }

    public final void setStatus(@NotNull QueryStatus queryStatus) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)queryStatus), (String)"<set-?>");
        this.status = queryStatus;
    }

    public final long getTimeInSeconds() {
        return this.timeInSeconds;
    }

    @NotNull
    public final ScheduledExecutorService getServiceTimeout() {
        return this.serviceTimeout;
    }

    @Nullable
    public final ScheduledFuture<?> getScheduledServiceResult() {
        return this.scheduledServiceResult;
    }

    public final void setScheduledServiceResult(@Nullable ScheduledFuture<?> scheduledFuture) {
        this.scheduledServiceResult = scheduledFuture;
    }

    public final void cancel() {
        if (this.status == QueryStatus.PROCESSING) {
            this.updateStatus(QueryStatus.CANCELLED);
        }
    }

    public final void execute(@NotNull Runnable runnable) {
        Intrinsics.checkParameterIsNotNull((Object)runnable, (String)"runnable");
        this.status = QueryStatus.PROCESSING;
        this.scheduledServiceResult = this.serviceTimeout.schedule(this.r, this.timeInSeconds, TimeUnit.SECONDS);
        this.serviceExecutor.execute(runnable);
    }

    public final boolean failed() {
        boolean bl;
        if (this.status != QueryStatus.CANCELLED && this.status != QueryStatus.TIMED_OUT) {
            this.updateStatus(QueryStatus.FAILED);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public final boolean success() {
        boolean bl;
        if (this.status != QueryStatus.CANCELLED && this.status != QueryStatus.TIMED_OUT) {
            this.updateStatus(QueryStatus.SUCCESS);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private final void cancelRequest() {
        if (!this.serviceExecutor.isShutdown()) {
            this.serviceExecutor.shutdownNow();
        }
    }

    private final void cancelTimeout() {
        block0: {
            ScheduledFuture<?> scheduledFuture = this.scheduledServiceResult;
            if (scheduledFuture == null) break block0;
            scheduledFuture.cancel(true);
        }
    }

    private final void updateStatus(QueryStatus status) {
        this.status = status;
        this.cancelRequest();
        this.cancelTimeout();
    }

    @NotNull
    public final ExecutorService getServiceExecutor() {
        return this.serviceExecutor;
    }

    public FlybitsResult(@NotNull ExecutorService serviceExecutor, long time, @NotNull TimeUnit unit) {
        Intrinsics.checkParameterIsNotNull((Object)serviceExecutor, (String)"serviceExecutor");
        Intrinsics.checkParameterIsNotNull((Object)((Object)unit), (String)"unit");
        this.serviceExecutor = serviceExecutor;
        this.status = QueryStatus.INITIALIZED;
        this.timeInSeconds = TimeUnit.SECONDS.convert(time, unit);
        ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1);
        Intrinsics.checkExpressionValueIsNotNull((Object)scheduledExecutorService, (String)"Executors.newScheduledThreadPool(1)");
        this.serviceTimeout = scheduledExecutorService;
        this.r = new Runnable(this){
            final /* synthetic */ FlybitsResult this$0;

            public final void run() {
                if (this.this$0.getStatus() == QueryStatus.PROCESSING) {
                    FlybitsResult.access$updateStatus(this.this$0, QueryStatus.TIMED_OUT);
                }
            }
            {
                this.this$0 = flybitsResult;
            }
        };
    }

    public /* synthetic */ FlybitsResult(ExecutorService executorService, long l, TimeUnit timeUnit, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            ExecutorService executorService2 = Executors.newSingleThreadExecutor();
            Intrinsics.checkExpressionValueIsNotNull((Object)executorService2, (String)"Executors.newSingleThreadExecutor()");
            executorService = executorService2;
        }
        if ((n & 2) != 0) {
            l = 30L;
        }
        if ((n & 4) != 0) {
            timeUnit = DEFAULT_TIMEOUT_UNIT;
        }
        this(executorService, l, timeUnit);
    }

    public FlybitsResult() {
        this(null, 0L, null, 7, null);
    }

    static {
        Companion = new Companion(null);
        DEFAULT_TIMEOUT_UNIT = TimeUnit.SECONDS;
    }

    public static final /* synthetic */ void access$updateStatus(FlybitsResult $this, QueryStatus status) {
        $this.updateStatus(status);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/flybits/commons/library/api/results/FlybitsResult$Companion;", "", "()V", "DEFAULT_TIMEOUT", "", "DEFAULT_TIMEOUT_UNIT", "Ljava/util/concurrent/TimeUnit;", "commons_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

