package com.flybits.commons.library.deserializations

import com.flybits.commons.library.models.UserOptedIn
import org.json.JSONArray
import org.json.JSONObject

class DeserializeUserOptedIn: IDeserializer<UserOptedIn>() {

    override fun toJson(obj: UserOptedIn?): String {
        val json = JSONObject()
        json.put(UserOptedIn.FIELD_IS_ACTIVE, obj?.isOptedIn)
        return json.toString()
    }

    override fun fromJson(jsonObject: JSONObject): UserOptedIn {
        return UserOptedIn(jsonObject.getBoolean(UserOptedIn.FIELD_IS_ACTIVE))
    }

    override fun fromJson(jsonObject: JSONArray): UserOptedIn {
        return if (jsonObject.length() > 0) {
            UserOptedIn(jsonObject.getJSONObject(0).getBoolean(UserOptedIn.FIELD_IS_ACTIVE))
        } else UserOptedIn(false)
    }
}