package com.flybits.commons

import android.content.Context
import com.flybits.commons.library.SharedElementsFactory
import com.flybits.commons.library.api.FlybitsScope
import com.flybits.commons.library.logging.Logger
import com.flybits.commons.library.models.Device
import com.flybits.commons.library.models.User
import com.google.firebase.iid.FirebaseInstanceId
import com.google.firebase.iid.InstanceIdResult

const val TAG = "CommonScope"
class CommonScope private constructor() : FlybitsScope("CommonScope") {

    lateinit var context: Context

    constructor(context: Context) : this() {
        this.context = context
    }

    override fun onOptedStateChange(context: Context?, optedState: Boolean) {
    }

    override fun onConnected(context: Context?, user: User?) {

    }

    override fun onAccountDestroyed(context: Context?, jwtToken: String?) {
    }

    override fun onDisconnected(context: Context?, jwtToken: String?) {
    }

    override fun onStart() {
        Logger.appendTag(TAG).d("CommonScope onStart() called.")
        val sharedElements = SharedElementsFactory.get(context)
        if(sharedElements.getUniqueDeviceId().isBlank()){
            FirebaseInstanceId.getInstance().instanceId.addOnSuccessListener { instanceIdResult: InstanceIdResult ->
                val newlyGeneratedPhysicalId = instanceIdResult.id
                sharedElements.setUniqueDevice(newlyGeneratedPhysicalId)

                if (sharedElements.getSavedJWTToken().isBlank()) {
                    Logger.appendTag(TAG).d("User not logged In.")
                } else {
                    Device.addAssociationMigration(context, newlyGeneratedPhysicalId)
                    Logger.appendTag(TAG).d("Added a Firebase physical device identifier.")
                }
            }
        }
        else {
            Logger.appendTag(TAG).d("physicalDevice is unchanged.")
        }
    }

    override fun onStop() {
    }
}