/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.api;

import android.content.Context;
import com.flybits.commons.library.api.FlybitsScope;
import com.flybits.commons.library.logging.Logger;
import com.flybits.commons.library.models.User;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0006H\u0007J\r\u0010\u000f\u001a\u00020\rH\u0001\u00a2\u0006\u0002\b\u0010J\u0016\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0005J\u0016\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017J\u0016\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0005J\u0016\u0010\u0019\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0006J\u000e\u0010\u001d\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0006J\u0010\u0010\u001e\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0006H\u0007R0\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0007\u0010\u0002\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u001f"}, d2={"Lcom/flybits/commons/library/api/ScopeOfficer;", "", "()V", "flybitsScopes", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/flybits/commons/library/api/FlybitsScope;", "flybitsScopes$annotations", "getFlybitsScopes", "()Ljava/util/concurrent/ConcurrentHashMap;", "setFlybitsScopes", "(Ljava/util/concurrent/ConcurrentHashMap;)V", "addScope", "", "scope", "clearScopes", "clearScopes$commons_release", "onAccountDestroyed", "context", "Landroid/content/Context;", "jwtToken", "onConnected", "user", "Lcom/flybits/commons/library/models/User;", "onDisconnected", "onOptedStateChange", "optedState", "", "onStart", "onStop", "removeScope", "commons_release"})
public final class ScopeOfficer {
    @NotNull
    private static ConcurrentHashMap<String, FlybitsScope> flybitsScopes;
    public static final ScopeOfficer INSTANCE;

    @JvmStatic
    public static /* synthetic */ void flybitsScopes$annotations() {
    }

    @NotNull
    public static final ConcurrentHashMap<String, FlybitsScope> getFlybitsScopes() {
        return flybitsScopes;
    }

    public static final void setFlybitsScopes(@NotNull ConcurrentHashMap<String, FlybitsScope> concurrentHashMap) {
        Intrinsics.checkParameterIsNotNull(concurrentHashMap, (String)"<set-?>");
        flybitsScopes = concurrentHashMap;
    }

    @JvmStatic
    public static final void addScope(@NotNull FlybitsScope scope) {
        Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
        Logger.i("Adding Scope " + scope.getScopeName());
        Map map = flybitsScopes;
        String string = scope.getScopeName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"scope.scopeName");
        map.put(string, scope);
        INSTANCE.onStart(scope);
    }

    @JvmStatic
    public static final void removeScope(@NotNull FlybitsScope scope) {
        Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
        Logger.i("Removing Scope " + scope.getScopeName() + "...");
        Iterator<Map.Entry<String, FlybitsScope>> it = flybitsScopes.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, FlybitsScope> item;
            Intrinsics.checkExpressionValueIsNotNull(it.next(), (String)"it.next()");
            if (!Intrinsics.areEqual((Object)item.getKey(), (Object)scope.getScopeName())) continue;
            it.remove();
            INSTANCE.onStop(scope);
            Logger.i("Removing Scope " + scope.getScopeName() + " ... Success");
        }
    }

    @JvmStatic
    public static final void clearScopes$commons_release() {
        Logger.i("Clearing all scopes");
        flybitsScopes.clear();
    }

    public final void onStart(@NotNull FlybitsScope scope) {
        Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
        Logger.i("ScopeOfficer detected an onStart");
        scope.onStart();
        Logger.i("... calling onStart of " + scope.getScopeName());
    }

    public final void onStop(@NotNull FlybitsScope scope) {
        Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
        Logger.i("ScopeOfficer detected an onStop");
        scope.onStop();
        Logger.i("... calling onStop of " + scope.getScopeName());
    }

    public final void onConnected(@NotNull Context context, @NotNull User user) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        Logger.i("ScopeOfficer detected an onConnected");
        for (Object e : flybitsScopes.keySet()) {
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"it.next()");
            String item = (String)e;
            Logger.i("... calling onConnected of " + item);
            FlybitsScope flybitsScope = flybitsScopes.get(item);
            if (flybitsScope == null) continue;
            flybitsScope.onConnected(context, user);
        }
    }

    public final void onDisconnected(@NotNull Context context, @NotNull String jwtToken) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)jwtToken, (String)"jwtToken");
        Logger.i("ScopeOfficer detected an onDisconnected");
        for (Object e : flybitsScopes.keySet()) {
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"it.next()");
            String item = (String)e;
            Logger.i("... calling onDisconnected of " + item);
            FlybitsScope flybitsScope = flybitsScopes.get(item);
            if (flybitsScope == null) continue;
            flybitsScope.onDisconnected(context, jwtToken);
        }
    }

    public final void onAccountDestroyed(@NotNull Context context, @NotNull String jwtToken) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)jwtToken, (String)"jwtToken");
        Logger.i("ScopeOfficer detected an onAccountDestroyed");
        for (Object e : flybitsScopes.keySet()) {
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"it.next()");
            String item = (String)e;
            Logger.i("... calling onAccountDestroyed of " + item);
            FlybitsScope flybitsScope = flybitsScopes.get(item);
            if (flybitsScope == null) continue;
            flybitsScope.onAccountDestroyed(context, jwtToken);
        }
    }

    public final void onOptedStateChange(@NotNull Context context, boolean optedState) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Logger.i("ScopeOfficer detected an onOptedStateChange");
        for (Object e : flybitsScopes.keySet()) {
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"it.next()");
            String item = (String)e;
            Logger.i("... calling onOptedStateChange of " + item);
            FlybitsScope flybitsScope = flybitsScopes.get(item);
            if (flybitsScope == null) continue;
            flybitsScope.onOptedStateChange(context, optedState);
        }
    }

    private ScopeOfficer() {
    }

    static {
        ScopeOfficer scopeOfficer;
        INSTANCE = scopeOfficer = new ScopeOfficer();
        flybitsScopes = new ConcurrentHashMap();
    }
}

