/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.utils;

import android.content.Context;
import android.os.Build;
import com.flybits.commons.library.SharedElementsFactory;
import com.flybits.commons.library.exceptions.InvalidPhysicalDeviceIdException;
import com.flybits.commons.library.logging.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/flybits/commons/library/utils/RequestUtilities;", "", "()V", "generateXUserAgentHeader", "Lorg/json/JSONObject;", "context", "Landroid/content/Context;", "commons_release"})
public final class RequestUtilities {
    @NotNull
    public final JSONObject generateXUserAgentHeader(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        JSONObject obj = new JSONObject();
        try {
            obj.put("make", (Object)Build.MANUFACTURER);
        }
        catch (JSONException exception) {
            Logger.appendTag("_Network").w("The make attribute could not be added to the request");
        }
        try {
            obj.put("model", (Object)Build.MODEL);
        }
        catch (JSONException exception) {
            Logger.appendTag("_Network").w("The model attribute could not be added to the request");
        }
        try {
            obj.put("osVersion", (Object)String.valueOf(Build.VERSION.SDK_INT));
        }
        catch (JSONException exception) {
            Logger.appendTag("_Network").w("The osVersion attribute could not be added to the request");
        }
        try {
            obj.put("deviceType", (Object)"Android");
        }
        catch (JSONException exception) {
            Logger.appendTag("_Network").w("The deviceType attribute could not be added to the request");
        }
        try {
            obj.put("sdkVersion", (Object)"2.4.2-rc22");
        }
        catch (JSONException exception) {
            Logger.appendTag("_Network").w("The sdkVersion attribute could not be added to the request");
        }
        try {
            obj.put("name", (Object)(Build.MANUFACTURER + '-' + Build.MODEL));
        }
        catch (JSONException exception) {
            Logger.appendTag("_Network").w("The name attribute could not be added to the request");
        }
        try {
            obj.put("physicalDeviceId", (Object)SharedElementsFactory.INSTANCE.get(context).getUniqueDeviceId());
        }
        catch (JSONException jsonException) {
            Logger.appendTag("_Network").w("The physicalDeviceId attribute could not be added to the request due to a json exception");
        }
        catch (InvalidPhysicalDeviceIdException physicalDeviceId) {
            Logger.appendTag("_Network").w("The physicalDeviceId attribute could not be added to the request due to an invalid physical device Id");
        }
        catch (NullPointerException nullPointer) {
            Logger.appendTag("_Network").w("The physicalDeviceId attribute could not be added to the request due to an invalid DefaultUniqueDeviceIdGenerator");
        }
        return obj;
    }
}

