/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.http;

import android.content.Context;
import android.support.annotation.NonNull;
import com.flybits.commons.library.SharedElements;
import com.flybits.commons.library.SharedElementsFactory;
import com.flybits.commons.library.api.FlyJWT;
import com.flybits.commons.library.exceptions.FlybitsDisabledException;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.exceptions.NotConnectedException;
import com.flybits.commons.library.http.HttpHelper;
import com.flybits.commons.library.http.RequestStatus;
import com.flybits.commons.library.logging.Logger;
import com.flybits.commons.library.models.internal.QueryParameters;
import com.flybits.commons.library.models.internal.Result;
import com.flybits.commons.library.utils.Utilities;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.Buffer;
import okio.BufferedSink;

public class HttpDefaultClass<T> {
    private static final String TAG_NETWORK = "Network";
    private int timeout;
    private Context context;
    private boolean shouldRefreshJWT;
    private OkHttpClient client;
    private Request request;
    private SharedElements sharedElements;

    public HttpDefaultClass(Builder builder) {
        this.context = builder.mContext;
        this.shouldRefreshJWT = builder.mShouldRefreshJWT;
        this.request = builder.mRequest.build();
        this.client = HttpHelper.getClient().getClient();
        this.sharedElements = SharedElementsFactory.INSTANCE.get(this.context);
        this.printHttpRequest();
    }

    private void printHttpRequest() {
        Logger.appendTag(TAG_NETWORK).d("Request URL - " + this.request.url().toString());
        Headers headers = this.request.headers();
        Set headersName = headers.names();
        for (String iteratorAsString : headersName) {
            Logger.appendTag(TAG_NETWORK).d("Request Header - (" + iteratorAsString + " = " + headers.get(iteratorAsString) + ")");
        }
        if (this.request.body() != null) {
            try {
                Buffer buffer = new Buffer();
                Request copy = this.request.newBuilder().build();
                copy.body().writeTo((BufferedSink)buffer);
                String body2 = buffer.readUtf8();
                Logger.appendTag(TAG_NETWORK).d("Request Body - " + body2);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    Request getRequest() {
        return this.request;
    }

    public Result<T> getResponse() throws IOException, FlybitsDisabledException {
        long timeStart = System.currentTimeMillis();
        try {
            int MAXTIMEOUT;
            Response response = this.client.newCall(this.request).execute();
            int statusCode = response.code();
            Logger.appendTag(TAG_NETWORK).d("Response - Time to Process Request: " + (System.currentTimeMillis() - timeStart));
            Logger.appendTag(TAG_NETWORK).d("Response Code: " + statusCode);
            String messageBody = null;
            if (response.body() != null) {
                messageBody = response.body().string();
                Logger.appendTag(TAG_NETWORK).d("Response - Result: " + messageBody);
            }
            if (statusCode == 503) {
                throw new FlybitsDisabledException("Flybits is currently not available");
            }
            if (statusCode == 401 && this.shouldRefreshJWT && this.timeout < (MAXTIMEOUT = 1)) {
                ++this.timeout;
                try {
                    FlyJWT jwt = FlyJWT.Companion.get(this.context);
                    Result<?> refreshResult = jwt.refresh();
                    if (refreshResult.getStatus() == RequestStatus.COMPLETED) {
                        return this.getResponse();
                    }
                    if (refreshResult.getException() instanceof NotConnectedException) {
                        return new Result(401, refreshResult.getException().getMessage());
                    }
                    return refreshResult;
                }
                catch (FlybitsException e) {
                    Logger.exception("FlybitsHttpRequest.getResponse", e);
                    return new Result(500, e.getMessage());
                }
            }
            Headers responseHeaders = response.headers();
            String jwtTokenValue = responseHeaders.get("X-Authorization");
            if (jwtTokenValue != null && jwtTokenValue.length() > 0) {
                this.sharedElements.setJWTToken(jwtTokenValue);
                Logger.appendTag(TAG_NETWORK).d("Jwt from Response Headers[X-Authorization] is saved in sharedElements.");
            }
            return new Result(statusCode, messageBody);
        }
        catch (SocketTimeoutException exception) {
            return new Result(504, "Request Timed Out");
        }
        catch (SocketException exception) {
            return new Result(500, "Socket Exception");
        }
    }

    public static class Builder {
        private Context mContext;
        private boolean mShouldRefreshJWT;
        private String mUrl;
        private Request.Builder mRequest;

        public Builder(Context context, boolean shouldRefreshJWT, String endpoint) {
            this.mContext = context;
            this.mShouldRefreshJWT = shouldRefreshJWT;
            this.mUrl = SharedElementsFactory.INSTANCE.get(context).getGatewayURL() + endpoint;
            this.mRequest = new Request.Builder();
        }

        public Builder(Context context, boolean shouldRefreshJWT, String endpoint, QueryParameters params) {
            this.mContext = context;
            this.mShouldRefreshJWT = shouldRefreshJWT;
            String url = SharedElementsFactory.INSTANCE.get(context).getGatewayURL() + endpoint;
            this.mRequest = new Request.Builder();
            if (params != null && params.getQueryParams() != null && params.getQueryParams().size() > 0) {
                url = url + "?";
                StringBuilder urlBuilder = new StringBuilder(url);
                for (Map.Entry<String, ArrayList<String>> entries : params.getQueryParams().entrySet()) {
                    for (String entry : entries.getValue()) {
                        if (entries.getKey() == null || entries.getKey().length() == 0) {
                            urlBuilder.append(entry);
                        } else {
                            try {
                                urlBuilder.append(entries.getKey()).append("=").append(URLEncoder.encode(entry, "UTF-8"));
                            }
                            catch (UnsupportedEncodingException e) {
                                urlBuilder.append(entries.getKey()).append("=").append(entry);
                            }
                        }
                        urlBuilder.append("&");
                    }
                }
                url = urlBuilder.toString();
                url = url.substring(0, url.length() - 1);
            }
            this.mUrl = url;
        }

        public Builder(Context context, boolean shouldRefreshJWT, String endpoint, Map<String, String> queryParams) {
            this.mContext = context;
            this.mShouldRefreshJWT = shouldRefreshJWT;
            String url = SharedElementsFactory.INSTANCE.get(context).getGatewayURL() + endpoint;
            this.mRequest = new Request.Builder();
            HttpUrl.Builder urlBuilder = HttpUrl.parse((String)url).newBuilder();
            if (queryParams != null) {
                for (Map.Entry<String, String> entry : queryParams.entrySet()) {
                    urlBuilder.addQueryParameter(entry.getKey(), entry.getValue());
                }
            }
            this.mUrl = urlBuilder.build().toString();
        }

        public Builder addHeaders(@NonNull HashMap<String, String> headers) {
            if (headers != null && headers.size() > 0) {
                this.headers(headers);
            }
            return this;
        }

        public Builder addHeader(String key, String value) {
            HashMap<String, String> listOfHeaders = new HashMap<String, String>();
            listOfHeaders.put(key, value);
            this.headers(listOfHeaders);
            return this;
        }

        public HttpDefaultClass delete() {
            this.setupRequest();
            this.mRequest.delete();
            return new HttpDefaultClass(this);
        }

        public HttpDefaultClass delete(String json) {
            this.setupRequest();
            RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)json);
            this.mRequest.delete(requestBody);
            return new HttpDefaultClass(this);
        }

        public HttpDefaultClass get() {
            this.setupRequest();
            this.mRequest.get();
            return new HttpDefaultClass(this);
        }

        public HttpDefaultClass post(RequestBody requestBody) {
            this.setupRequest();
            this.mRequest.post(requestBody);
            return new HttpDefaultClass(this);
        }

        public HttpDefaultClass post(String json) {
            this.setupRequest();
            RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)json);
            this.mRequest.post(requestBody);
            return new HttpDefaultClass(this);
        }

        public HttpDefaultClass post(HashMap<String, String> formParams) {
            this.setupRequest();
            FormBody.Builder formBody = new FormBody.Builder();
            Iterator<Map.Entry<String, String>> it = formParams.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, String> pair = it.next();
                formBody.add(pair.getKey(), pair.getValue());
                it.remove();
            }
            this.mRequest.post((RequestBody)formBody.build());
            return new HttpDefaultClass(this);
        }

        public HttpDefaultClass put(RequestBody requestBody) {
            this.setupRequest();
            this.mRequest.put(requestBody);
            return new HttpDefaultClass(this);
        }

        public HttpDefaultClass put(String json) {
            this.setupRequest();
            RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)json);
            this.mRequest.put(requestBody);
            return new HttpDefaultClass(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setupRequest() {
            Builder builder = this;
            synchronized (builder) {
                SharedElements sharedElements = SharedElementsFactory.INSTANCE.get(this.mContext);
                this.mRequest.url(this.mUrl).header("X-User-Agent", Utilities.getUserAgentAsJSON(this.mContext)).header("Accept", "application/json").header("Content-Type", "application/json").header("Accept-Language", "all");
                String jwtToken = sharedElements.getSavedJWTToken();
                if (jwtToken.length() > 0) {
                    this.mRequest.header("X-Authorization", sharedElements.getSavedJWTToken());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void headers(HashMap<String, String> headers) {
            Builder builder = this;
            synchronized (builder) {
                if (headers != null) {
                    for (Map.Entry<String, String> entry : headers.entrySet()) {
                        this.mRequest.header(entry.getKey(), entry.getValue());
                    }
                }
            }
        }
    }
}

