/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.utils;

import android.os.Build;
import com.flybits.commons.library.DefaultUniqueDeviceIdGenerator;
import com.flybits.commons.library.exceptions.InvalidPhysicalDeviceIdException;
import com.flybits.commons.library.logging.Logger;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/flybits/commons/library/utils/RequestUtilities;", "", "()V", "generateXUserAgentHeader", "Lorg/json/JSONObject;", "advertisingIdClientInfo", "Lcom/google/android/gms/ads/identifier/AdvertisingIdClient$Info;", "commons_release"})
public final class RequestUtilities {
    @NotNull
    public final JSONObject generateXUserAgentHeader(@Nullable AdvertisingIdClient.Info advertisingIdClientInfo) {
        JSONObject obj = new JSONObject();
        try {
            obj.put("make", (Object)Build.MANUFACTURER);
        }
        catch (JSONException exception) {
            Logger.appendTag("_Network").w("The make attribute could not be added to the request");
        }
        try {
            obj.put("model", (Object)Build.MODEL);
        }
        catch (JSONException exception) {
            Logger.appendTag("_Network").w("The model attribute could not be added to the request");
        }
        try {
            obj.put("osVersion", (Object)String.valueOf(Build.VERSION.SDK_INT));
        }
        catch (JSONException exception) {
            Logger.appendTag("_Network").w("The osVersion attribute could not be added to the request");
        }
        try {
            obj.put("deviceType", (Object)"Android");
        }
        catch (JSONException exception) {
            Logger.appendTag("_Network").w("The deviceType attribute could not be added to the request");
        }
        try {
            obj.put("sdkVersion", (Object)"2.3.4-alpha1");
        }
        catch (JSONException exception) {
            Logger.appendTag("_Network").w("The sdkVersion attribute could not be added to the request");
        }
        try {
            obj.put("name", (Object)(Build.MANUFACTURER + '-' + Build.MODEL));
        }
        catch (JSONException exception) {
            Logger.appendTag("_Network").w("The name attribute could not be added to the request");
        }
        try {
            if (advertisingIdClientInfo != null) {
                DefaultUniqueDeviceIdGenerator uniqueDeviceIdGenerator = new DefaultUniqueDeviceIdGenerator(advertisingIdClientInfo);
                String uniqueDeviceId = uniqueDeviceIdGenerator.generateUniqueDeviceId();
                CharSequence charSequence = uniqueDeviceId;
                boolean bl = false;
                if (charSequence.length() > 0) {
                    obj.put("physicalDeviceId", (Object)uniqueDeviceId);
                }
            }
        }
        catch (JSONException jsonException) {
            Logger.appendTag("_Network").w("The physicalDeviceId attribute could not be added to the request due to a json exception");
        }
        catch (InvalidPhysicalDeviceIdException physicalDeviceId) {
            Logger.appendTag("_Network").w("The physicalDeviceId attribute could not be added to the request due to an invalid physical device Id");
        }
        catch (NullPointerException nullPointer) {
            Logger.appendTag("_Network").w("The physicalDeviceId attribute could not be added to the request due to an invalid DefaultUniqueDeviceIdGenerator");
        }
        return obj;
    }

    public static /* synthetic */ JSONObject generateXUserAgentHeader$default(RequestUtilities requestUtilities, AdvertisingIdClient.Info info, int n, Object object) {
        if ((n & 1) != 0) {
            info = null;
        }
        return requestUtilities.generateXUserAgentHeader(info);
    }
}

