package com.flybits.commons.library.logging

/**
 * Logger is an internal class that used to log information to the logcat.
 */
object Logger {

    /**
     * Retrieve the [Displayer] that displays information within the logcat.
     *
     * @return The [Displayer] that displays the information in the logcat.
     */
    @JvmStatic
    internal val displayer = Displayer()

    /**
     * Set the Tag that the logcat information is set under.
     *
     * @param tag The tag that is used to display information within the logcat under.
     * @return The [Displayer] that displays the information in the logcat.
     */
    @JvmStatic
    @Deprecated("Deprecated in version 2.1.0, will be removed in version 4.0.0",
        ReplaceWith("appendTag(String)", "com.flybits.commons.library.logging.Logger"))
    fun setTag(tag: String): Displayer {
        return displayer.changeTag(tag)
    }

    /**
     * Set the Tag filter that the logcat information is set under.
     *
     * @param filter The filter that is appended to the Tag to make searching easier.
     * @return The [Displayer] that displays the information in the logcat.
     */
    @JvmStatic
    fun appendTag(filter: String): Displayer {
        return displayer.appendTag(filter)
    }

    /**
     * Set the logging verbosity for all messages within the SDKs.
     *
     * @param level The level of verbosity that should be displayed. Log levels enum values
     * from [VerbosityLevel]. The default is level [VerbosityLevel.NONE].
     */
    @JvmStatic
    fun setVerbosity(level : VerbosityLevel) : Displayer{
        return displayer.setVerbosity(level)
    }

    /**
     * Creates a log statement in the logcat that displays information used to debug the Flybits
     * SDK.
     *
     * @param msg - The message to be displayed in the logcat.
     */
    @JvmStatic
    fun d(msg: String) {
        displayer.d(msg)
    }

    /**
     * Creates a log statement in the logcat that displays an error.
     *
     * @param msg - The message to be displayed in the logcat.
     */
    @JvmStatic
    fun e(msg: String) {
        displayer.e(msg)
    }

    /**
     * Creates a log statement in the logcat that displays some information.
     *
     * @param msg - The message to be displayed in the logcat.
     */
    @JvmStatic
    fun i(msg: String) {
        displayer.i(msg)
    }

    /**
     * Creates a log statement in the logcat that displays a warning.
     *
     * @param msg - The message to be displayed in the logcat.
     */
    @JvmStatic
    fun w(msg: String) {
        displayer.w(msg)
    }

    /**
     * Creates a log statement in the logcat that will display an exception's information and print
     * the stack trace. This is only available is the user has set activated logging when they
     * initiate Flybits for the first time.
     *
     * @param sdkMethod The name of the method where the error was caused.
     * @param e - The exception to display information about.
     *
     */
    @JvmStatic
    fun exception(sdkMethod: String, e: Exception) {
        displayer.exception(sdkMethod, e)
    }
}
