package com.flybits.commons.library.deserializations;


import com.flybits.commons.library.logging.Logger;
import com.flybits.commons.library.models.internal.PagedResponse;
import com.flybits.commons.library.models.internal.Pagination;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;

public class DeserializePagedResponse<T> extends IDeserializer<PagedResponse<T>> {

    private IDeserializer deserializer;

    public DeserializePagedResponse(IDeserializer deserializer){
        this.deserializer   = deserializer;
    }

    @Override
    public String toJson(PagedResponse<T> obj) {
        JSONArray object   = new JSONArray();
        return object.toString();
    }

    @Override
    public PagedResponse<T> fromJson(JSONObject jObj) {
        try {

            Pagination pagination = null;
            if (!jObj.isNull(KEY_PAGING)) {

                JSONObject paginationObj = jObj.getJSONObject(KEY_PAGING);
                if (!paginationObj.isNull("limit") && !paginationObj.isNull("totalRecords")
                        && !paginationObj.isNull("offset")){

                    int limit        = paginationObj.getInt("limit");
                    int offset       = paginationObj.getInt("offset");
                    int totalRecords = paginationObj.getInt("totalRecords");
                    pagination       = new Pagination(limit, offset, totalRecords);
                }else{
                    return null;
                }
            }

            if (!jObj.isNull(KEY_LIST_ITEM)) {
                ArrayList<T> items = new ArrayList<>();

                JSONArray dataArray = jObj.getJSONArray(KEY_LIST_ITEM);
                for (int i = 0; i < dataArray.length(); i++) {
                    JSONObject elementObj = dataArray.getJSONObject(i);
                    T deserializedItem  = (T) deserializer.fromJson(elementObj);
                    if (deserializedItem != null) {
                        items.add(deserializedItem);
                    }
                }
                return new PagedResponse<T>(items, pagination);
            }
        }catch (JSONException e){
            Logger.exception("DeserializePagedResponse.fromJson", e);
        }
        return null;
    }

    @Override
    public PagedResponse<T> fromJson(JSONArray jsonObject) {
        return null;
    }
}
