/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.encryption;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.security.KeyPairGeneratorSpec;
import android.security.keystore.KeyGenParameterSpec;
import android.util.Base64;
import com.flybits.commons.library.encryption.SecuredPreferenceStore;
import com.flybits.commons.library.logging.Logger;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.UnrecoverableEntryException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.x500.X500Principal;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0011\u0018\u0000 y2\u00020\u0001:\u0003yz{B#\b\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bB5\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010B\u001a\u00020\f2\b\u0010C\u001a\u0004\u0018\u00010\fJ\u0010\u0010D\u001a\u00020\f2\b\u0010C\u001a\u0004\u0018\u00010\fJ\u0010\u0010E\u001a\u00020\f2\b\u0010F\u001a\u0004\u0018\u00010\fJ\u000e\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020\nJ\u0012\u0010J\u001a\u0004\u0018\u00010\f2\b\u0010F\u001a\u0004\u0018\u00010HJ\u0016\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020OJ\u0012\u0010J\u001a\u0004\u0018\u00010\n2\b\u0010I\u001a\u0004\u0018\u00010\nJ\u0010\u0010P\u001a\u00020\f2\u0006\u0010Q\u001a\u00020HH\u0007J\u000e\u0010R\u001a\u00020\f2\u0006\u0010Q\u001a\u00020HJ\u0010\u0010S\u001a\u00020\n2\u0006\u0010F\u001a\u00020HH\u0002J\u0016\u0010T\u001a\u00020K2\u0006\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020OJ\u0012\u0010T\u001a\u0004\u0018\u00010H2\b\u0010C\u001a\u0004\u0018\u00010\fJ\u0012\u0010T\u001a\u0004\u0018\u00010\n2\b\u0010I\u001a\u0004\u0018\u00010\nJ\u001c\u0010U\u001a\u00020H2\b\u0010C\u001a\u0004\u0018\u00010\f2\b\u0010V\u001a\u0004\u0018\u00010\fH\u0007J\u001a\u0010W\u001a\u00020H2\b\u0010C\u001a\u0004\u0018\u00010\f2\b\u0010V\u001a\u0004\u0018\u00010\fJ\u0012\u0010X\u001a\u00020-2\b\u0010Y\u001a\u0004\u0018\u00010\fH\u0007J\u0018\u0010Z\u001a\u00020-2\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010Y\u001a\u0004\u0018\u00010\fJ\"\u0010[\u001a\u00020-2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\u0010Y\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0004\u001a\u00020\u0005J\u0018\u0010\\\u001a\u00020-2\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010Y\u001a\u0004\u0018\u00010\fJ\u001c\u0010]\u001a\u00020-2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\u0010Y\u001a\u0004\u0018\u00010\fH\u0007J\u001a\u0010^\u001a\u00020_2\b\u0010V\u001a\u0004\u0018\u00010\f2\u0006\u0010`\u001a\u00020-H\u0007J\u0018\u0010a\u001a\u00020_2\b\u0010V\u001a\u0004\u0018\u00010\f2\u0006\u0010`\u001a\u00020-J\u0010\u0010b\u001a\u0004\u0018\u00010(2\u0006\u0010\u0004\u001a\u00020\u0005J\u0012\u0010c\u001a\u0004\u0018\u00010(2\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005J%\u0010d\u001a\u00020-\"\u0010\b\u0000\u0010e*\n\u0018\u00010fj\u0004\u0018\u0001`g2\u0006\u0010h\u001a\u0002He\u00a2\u0006\u0002\u0010iJ\u0010\u0010j\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0kH\u0002J\u000e\u0010l\u001a\u00020K2\u0006\u0010\u0004\u001a\u00020\u0005J\u0006\u0010m\u001a\u00020KJ\u0006\u0010n\u001a\u00020KJ\"\u0010o\u001a\u00020K2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010Y\u001a\u0004\u0018\u00010\fJ\u0012\u0010p\u001a\u0004\u0018\u00010\f2\b\u0010F\u001a\u0004\u0018\u00010HJ\u0016\u0010p\u001a\u00020K2\u0006\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020OJ\u0016\u0010q\u001a\u00020K2\u0006\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020OJ\u0012\u0010q\u001a\u0004\u0018\u00010H2\b\u0010C\u001a\u0004\u0018\u00010\fJ#\u0010r\u001a\u00020-\"\f\b\u0000\u0010e*\u00060fj\u0002`g2\u0006\u0010s\u001a\u0002HeH\u0002\u00a2\u0006\u0002\u0010iJ\u001a\u0010t\u001a\u00020-2\b\u0010u\u001a\u0004\u0018\u00010\f2\b\u0010F\u001a\u0004\u0018\u00010\fJ\u001a\u0010v\u001a\u00020\f2\u0006\u0010w\u001a\u00020\f2\b\u0010x\u001a\u0004\u0018\u00010\fH\u0002R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0010X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0010X\u0082D\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001a\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0015R\u000e\u0010\u001c\u001a\u00020\u0010X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0010X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u0011\u0010 \u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0015R\u000e\u0010\"\u001a\u00020\u0010X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010'\u001a\u0004\u0018\u00010(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010)\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u000e\u0010,\u001a\u00020-X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010.\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00100\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104R\u001c\u00105\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u00107\"\u0004\b8\u00109R\u000e\u0010:\u001a\u00020;X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010<\u001a\u0004\u0018\u00010(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010=\u001a\u0004\u0018\u00010>X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010?\u001a\u0004\u0018\u00010@X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010A\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006|"}, d2={"Lcom/flybits/commons/library/encryption/EncryptionManager;", "", "context", "Landroid/content/Context;", "prefStore", "Landroid/content/SharedPreferences;", "recoveryNotifier", "Lcom/flybits/commons/library/encryption/SecuredPreferenceStore$KeyStoreRecoveryNotifier;", "(Landroid/content/Context;Landroid/content/SharedPreferences;Lcom/flybits/commons/library/encryption/SecuredPreferenceStore$KeyStoreRecoveryNotifier;)V", "keyAliasPrefix", "", "bitShiftingKey", "", "recoveryHandler", "(Landroid/content/Context;Landroid/content/SharedPreferences;Ljava/lang/String;[BLcom/flybits/commons/library/encryption/SecuredPreferenceStore$KeyStoreRecoveryNotifier;)V", "AES_BIT_LENGTH", "", "AES_CIPHER", "AES_CIPHER_COMPAT", "AES_KEY_ALIAS", "getAES_KEY_ALIAS", "()Ljava/lang/String;", "BOUNCY_CASTLE_PROVIDER", "COMPAT_IV_LENGTH", "DELIMITER", "GCM_TAG_LENGTH", "IS_COMPAT_MODE_KEY_ALIAS", "getIS_COMPAT_MODE_KEY_ALIAS", "IV_LENGTH", "KEYSTORE_PROVIDER", "MAC_BIT_LENGTH", "MAC_CIPHER", "MAC_KEY_ALIAS", "getMAC_KEY_ALIAS", "RSA_BIT_LENGTH", "RSA_CIPHER", "RSA_KEY_ALIAS", "SHIFTING_KEY", "SSL_PROVIDER", "aesKey", "Ljavax/crypto/SecretKey;", "iV", "getIV", "()[B", "isCompatMode", "", "mContext", "mKeyAliasPrefix", "mPrefs", "getMPrefs", "()Landroid/content/SharedPreferences;", "setMPrefs", "(Landroid/content/SharedPreferences;)V", "mRecoveryHandler", "getMRecoveryHandler", "()Lcom/flybits/commons/library/encryption/SecuredPreferenceStore$KeyStoreRecoveryNotifier;", "setMRecoveryHandler", "(Lcom/flybits/commons/library/encryption/SecuredPreferenceStore$KeyStoreRecoveryNotifier;)V", "mStore", "Ljava/security/KeyStore;", "macKey", "privateKey", "Ljava/security/interfaces/RSAPrivateKey;", "publicKey", "Ljava/security/interfaces/RSAPublicKey;", "x500_PRINCIPAL", "RSADecrypt", "bytes", "RSAEncrypt", "computeMac", "data", "decodeEncryptedText", "Lcom/flybits/commons/library/encryption/EncryptionManager$EncryptedData;", "text", "decrypt", "", "fileIn", "Ljava/io/BufferedInputStream;", "fileOut", "Ljava/io/BufferedOutputStream;", "decryptAES", "encryptedData", "decryptAESCompat", "encodeEncryptedData", "encrypt", "encryptAES", "IV", "encryptAESCompat", "generateAESKey", "seed", "generateFallbackAESKey", "generateKey", "generateMacKey", "generateRSAKeys", "getCipherAES", "Ljavax/crypto/Cipher;", "modeEncrypt", "getCipherAESCompat", "getFallbackAESKey", "getMacKey", "isRecoverableError", "T", "Ljava/lang/Exception;", "Lkotlin/Exception;", "error", "(Ljava/lang/Exception;)Z", "keyAliases", "", "loadKey", "loadKeyStore", "loadRSAKeys", "setup", "tryDecrypt", "tryEncrypt", "tryRecovery", "e", "verifyMac", "mac", "xorWithKey", "a", "key", "Companion", "EncryptedData", "InvalidMacException", "commons_release"})
public final class EncryptionManager {
    private final int RSA_BIT_LENGTH = 2048;
    private final int AES_BIT_LENGTH = 256;
    private final int MAC_BIT_LENGTH = 256;
    private final int GCM_TAG_LENGTH = 128;
    private final int COMPAT_IV_LENGTH = 16;
    private final int IV_LENGTH = 12;
    private final String KEYSTORE_PROVIDER = "AndroidKeyStore";
    private final String SSL_PROVIDER = "AndroidOpenSSL";
    private final String BOUNCY_CASTLE_PROVIDER = "BC";
    private final byte[] SHIFTING_KEY;
    private final String RSA_KEY_ALIAS;
    @NotNull
    private final String AES_KEY_ALIAS;
    @NotNull
    private final String MAC_KEY_ALIAS;
    private final String DELIMITER = "]";
    private final String RSA_CIPHER = "RSA/ECB/PKCS1Padding";
    private final String AES_CIPHER = "AES/GCM/NoPadding";
    private final String AES_CIPHER_COMPAT = "AES/CBC/PKCS7Padding";
    private final String MAC_CIPHER = "HmacSHA256";
    @NotNull
    private final String IS_COMPAT_MODE_KEY_ALIAS;
    private KeyStore mStore;
    private SecretKey aesKey;
    private SecretKey macKey;
    private RSAPublicKey publicKey;
    private RSAPrivateKey privateKey;
    private final String mKeyAliasPrefix;
    private boolean isCompatMode;
    private final Context mContext;
    @NotNull
    private SharedPreferences mPrefs;
    @Nullable
    private SecuredPreferenceStore.KeyStoreRecoveryNotifier mRecoveryHandler;
    private final String x500_PRINCIPAL = "CN = Flybits, O = Flybits Mobile";
    private static final String DEFAULT_CHARSET = "UTF-8";
    private static final String RSA_KEY_ALIAS_NAME = "rsa_key";
    private static final String AES_KEY_ALIAS_NAME = "aes_key";
    private static final String MAC_KEY_ALIAS_NAME = "mac_key";
    @NotNull
    public static final String OVERRIDING_KEY_ALIAS_PREFIX_NAME = "OverridingAlias";
    @NotNull
    public static final String DEFAULT_KEY_ALIAS_PREFIX = "sps";
    private static final String KEY_ALGORITHM_AES = "AES";
    private static final String KEY_ALGORITHM_RSA = "RSA";
    private static final String BLOCK_MODE_ECB = "ECB";
    private static final String BLOCK_MODE_GCM = "GCM";
    private static final String BLOCK_MODE_CBC = "CBC";
    private static final String ENCRYPTION_PADDING_RSA_PKCS1 = "PKCS1Padding";
    private static final String ENCRYPTION_PADDING_PKCS7 = "PKCS7Padding";
    private static final String ENCRYPTION_PADDING_NONE = "NoPadding";
    private static final String MAC_ALGORITHM_HMAC_SHA256 = "HmacSHA256";
    private static final String ENCRYPTION_PADDING_OAEP = "OAEPPadding";
    private static final String IS_COMPAT_MODE_KEY_ALIAS_NAME = "data_in_compat";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final String getAES_KEY_ALIAS() {
        return this.AES_KEY_ALIAS;
    }

    @NotNull
    public final String getMAC_KEY_ALIAS() {
        return this.MAC_KEY_ALIAS;
    }

    @NotNull
    public final String getIS_COMPAT_MODE_KEY_ALIAS() {
        return this.IS_COMPAT_MODE_KEY_ALIAS;
    }

    @NotNull
    public final SharedPreferences getMPrefs() {
        return this.mPrefs;
    }

    public final void setMPrefs(@NotNull SharedPreferences sharedPreferences) {
        Intrinsics.checkParameterIsNotNull((Object)sharedPreferences, (String)"<set-?>");
        this.mPrefs = sharedPreferences;
    }

    @Nullable
    public final SecuredPreferenceStore.KeyStoreRecoveryNotifier getMRecoveryHandler() {
        return this.mRecoveryHandler;
    }

    public final void setMRecoveryHandler(@Nullable SecuredPreferenceStore.KeyStoreRecoveryNotifier keyStoreRecoveryNotifier) {
        this.mRecoveryHandler = keyStoreRecoveryNotifier;
    }

    public final <T extends Exception> boolean isRecoverableError(T error) {
        return error instanceof KeyStoreException || error instanceof UnrecoverableEntryException || error instanceof InvalidKeyException || error instanceof IllegalStateException || error instanceof IOException && error.getCause() != null && error.getCause() instanceof BadPaddingException;
    }

    public final void setup(@Nullable Context context, @NotNull SharedPreferences prefStore, @Nullable byte[] seed) throws NoSuchPaddingException, InvalidKeyException, NoSuchAlgorithmException, KeyStoreException, UnrecoverableEntryException, NoSuchProviderException, InvalidAlgorithmParameterException, IOException {
        SharedPreferences sharedPreferences;
        Intrinsics.checkParameterIsNotNull((Object)prefStore, (String)"prefStore");
        boolean keyGenerated = this.generateKey(context, seed, prefStore);
        if (keyGenerated && (sharedPreferences = this.mPrefs) != null && (sharedPreferences = sharedPreferences.edit()) != null && (sharedPreferences = sharedPreferences.putString(Companion.getHashed(OVERRIDING_KEY_ALIAS_PREFIX_NAME), this.mKeyAliasPrefix)) != null) {
            sharedPreferences.commit();
        }
        this.loadKey(prefStore);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final <T extends Exception> boolean tryRecovery(T e) {
        if (this.mRecoveryHandler == null) return false;
        SecuredPreferenceStore.KeyStoreRecoveryNotifier keyStoreRecoveryNotifier = this.mRecoveryHandler;
        if (keyStoreRecoveryNotifier == null) {
            Intrinsics.throwNpe();
        }
        KeyStore keyStore = this.mStore;
        if (keyStore == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mStore");
        }
        if (!keyStoreRecoveryNotifier.onRecoveryRequired(e, keyStore, this.keyAliases())) return false;
        return true;
    }

    private final List<String> keyAliases() {
        List<String> list = Arrays.asList(this.AES_KEY_ALIAS, this.RSA_KEY_ALIAS);
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"Arrays.asList(AES_KEY_ALIAS, RSA_KEY_ALIAS)");
        return list;
    }

    @Nullable
    public final EncryptedData tryEncrypt(@Nullable byte[] bytes) throws NoSuchPaddingException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, IOException, BadPaddingException, IllegalBlockSizeException, NoSuchProviderException, InvalidKeyException, KeyStoreException, UnrecoverableEntryException {
        EncryptedData result = null;
        boolean tryAgain = false;
        try {
            result = this.encrypt(bytes);
        }
        catch (Exception ex) {
            if (!this.isRecoverableError(ex)) {
                throw (Throwable)ex;
            }
            tryAgain = this.tryRecovery(ex);
        }
        if (tryAgain) {
            this.setup(this.mContext, this.mPrefs, null);
            result = this.encrypt(bytes);
        }
        return result;
    }

    public final void tryEncrypt(@NotNull BufferedInputStream fileIn, @NotNull BufferedOutputStream fileOut) throws IOException, NoSuchProviderException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, InvalidKeyException, NoSuchPaddingException, KeyStoreException, UnrecoverableEntryException {
        Intrinsics.checkParameterIsNotNull((Object)fileIn, (String)"fileIn");
        Intrinsics.checkParameterIsNotNull((Object)fileOut, (String)"fileOut");
        boolean tryAgain = false;
        try {
            this.encrypt(fileIn, fileOut);
        }
        catch (Exception ex) {
            if (!this.isRecoverableError(ex)) {
                throw (Throwable)ex;
            }
            tryAgain = this.tryRecovery(ex);
        }
        if (tryAgain) {
            this.setup(this.mContext, this.mPrefs, null);
            this.encrypt(fileIn, fileOut);
        }
    }

    public final void tryDecrypt(@NotNull BufferedInputStream fileIn, @NotNull BufferedOutputStream fileOut) throws IOException, NoSuchProviderException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, InvalidKeyException, NoSuchPaddingException, KeyStoreException, UnrecoverableEntryException {
        Intrinsics.checkParameterIsNotNull((Object)fileIn, (String)"fileIn");
        Intrinsics.checkParameterIsNotNull((Object)fileOut, (String)"fileOut");
        boolean tryAgain = false;
        try {
            this.decrypt(fileIn, fileOut);
        }
        catch (Exception ex) {
            if (!this.isRecoverableError(ex)) {
                throw (Throwable)ex;
            }
            tryAgain = this.tryRecovery(ex);
        }
        if (tryAgain) {
            this.setup(this.mContext, this.mPrefs, null);
            this.decrypt(fileIn, fileOut);
        }
    }

    @Nullable
    public final byte[] tryDecrypt(@Nullable EncryptedData data) throws NoSuchPaddingException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, KeyStoreException, UnrecoverableEntryException, NoSuchProviderException, InvalidKeyException, IOException, BadPaddingException, IllegalBlockSizeException, InvalidMacException {
        byte[] result = null;
        boolean tryAgain = false;
        try {
            result = this.decrypt(data);
        }
        catch (Exception ex) {
            if (!this.isRecoverableError(ex)) {
                throw (Throwable)ex;
            }
            tryAgain = this.tryRecovery(ex);
        }
        if (tryAgain) {
            this.setup(this.mContext, this.mPrefs, null);
            result = this.decrypt(data);
        }
        return result;
    }

    @Nullable
    public final EncryptedData encrypt(@Nullable byte[] bytes) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, IOException, BadPaddingException, NoSuchProviderException, IllegalBlockSizeException, InvalidAlgorithmParameterException {
        if (bytes != null && bytes.length > 0) {
            byte[] IV = this.getIV();
            return this.isCompatMode ? this.encryptAESCompat(bytes, IV) : this.encryptAES(bytes, IV);
        }
        return null;
    }

    @Nullable
    public final byte[] decrypt(@Nullable EncryptedData data) throws IOException, NoSuchPaddingException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, IllegalBlockSizeException, BadPaddingException, InvalidMacException, NoSuchProviderException, InvalidKeyException {
        return data != null && data.getEncryptedData() != null ? (this.isCompatMode ? this.decryptAESCompat(data) : this.decryptAES(data)) : null;
    }

    @Nullable
    public final String encrypt(@Nullable String text) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, IOException, IllegalBlockSizeException, InvalidAlgorithmParameterException, NoSuchProviderException, BadPaddingException, KeyStoreException, UnrecoverableEntryException {
        if (text != null && text.length() > 0) {
            Object object;
            String string = text;
            Object object2 = DEFAULT_CHARSET;
            EncryptionManager encryptionManager2 = this;
            boolean bl = false;
            Charset charset = Charset.forName((String)object2);
            Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"Charset.forName(charsetName)");
            object2 = object = charset;
            bl = false;
            byte[] byArray = string.getBytes((Charset)object2);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            object = byArray;
            EncryptedData encryptedData = encryptionManager2.tryEncrypt((byte[])object);
            if (encryptedData == null) {
                return null;
            }
            EncryptedData encrypted = encryptedData;
            return this.encodeEncryptedData(encrypted);
        }
        return null;
    }

    @Nullable
    public final String decrypt(@Nullable String text) throws IOException, NoSuchPaddingException, InvalidKeyException, NoSuchAlgorithmException, IllegalBlockSizeException, BadPaddingException, InvalidMacException, NoSuchProviderException, InvalidAlgorithmParameterException, KeyStoreException, UnrecoverableEntryException {
        if (text != null) {
            CharSequence charSequence = text;
            boolean bl = false;
            if (charSequence.length() > 0) {
                EncryptedData encryptedData = this.decodeEncryptedText(text);
                byte[] byArray = this.tryDecrypt(encryptedData);
                if (byArray == null) {
                    return null;
                }
                byte[] decrypted = byArray;
                int n = 0;
                int n2 = decrypted.length;
                Object object = DEFAULT_CHARSET;
                boolean bl2 = false;
                Charset charset = Charset.forName((String)object);
                Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"Charset.forName(charsetName)");
                object = charset;
                bl2 = false;
                return new String(decrypted, n, n2, (Charset)object);
            }
        }
        return null;
    }

    public final void encrypt(@NotNull BufferedInputStream fileIn, @NotNull BufferedOutputStream fileOut) throws IOException, NoSuchProviderException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, InvalidKeyException, NoSuchPaddingException {
        Intrinsics.checkParameterIsNotNull((Object)fileIn, (String)"fileIn");
        Intrinsics.checkParameterIsNotNull((Object)fileOut, (String)"fileOut");
        byte[] IV = this.getIV();
        Cipher cipher = this.isCompatMode ? this.getCipherAESCompat(IV, true) : this.getCipherAES(IV, true);
        CipherOutputStream cipherOut = new CipherOutputStream(fileOut, cipher);
        fileOut.write(IV);
        byte[] buffer = new byte[4096];
        Ref.IntRef read = new Ref.IntRef();
        while (true) {
            int n = fileIn.read(buffer);
            boolean bl = false;
            boolean bl2 = false;
            int it = n;
            boolean bl3 = false;
            read.element = it;
            if (n == -1) break;
            cipherOut.write(buffer, 0, read.element);
        }
        cipherOut.flush();
        cipherOut.close();
        fileIn.close();
    }

    public final void decrypt(@NotNull BufferedInputStream fileIn, @NotNull BufferedOutputStream fileOut) throws IOException, NoSuchProviderException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, InvalidKeyException, NoSuchPaddingException {
        Intrinsics.checkParameterIsNotNull((Object)fileIn, (String)"fileIn");
        Intrinsics.checkParameterIsNotNull((Object)fileOut, (String)"fileOut");
        int IVLength = this.isCompatMode ? this.COMPAT_IV_LENGTH : this.IV_LENGTH;
        byte[] IV = new byte[IVLength];
        int read = fileIn.read(IV, 0, IVLength);
        boolean bl = read != -1 && read == IVLength;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Unexpected encryption state";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Cipher cipher = this.isCompatMode ? this.getCipherAESCompat(IV, false) : this.getCipherAES(IV, false);
        CipherInputStream cipherIn = new CipherInputStream(fileIn, cipher);
        byte[] buffer = new byte[4096];
        while (true) {
            int n = cipherIn.read(buffer);
            boolean bl5 = false;
            boolean bl6 = false;
            int it = n;
            boolean bl7 = false;
            read = it;
            if (n == -1) break;
            fileOut.write(buffer, 0, read);
        }
        fileOut.flush();
        fileOut.close();
        cipherIn.close();
    }

    private final String encodeEncryptedData(EncryptedData data) {
        return data.getMac() != null ? Companion.base64Encode(data.getIV()) + this.DELIMITER + Companion.base64Encode(data.getEncryptedData()) + this.DELIMITER + Companion.base64Encode(data.getMac()) : Companion.base64Encode(data.getIV()) + this.DELIMITER + Companion.base64Encode(data.getEncryptedData());
    }

    @NotNull
    public final EncryptedData decodeEncryptedText(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        EncryptedData result = new EncryptedData();
        CharSequence charSequence = text;
        String string = this.DELIMITER;
        int n = 0;
        string = new Regex(string);
        n = 0;
        boolean bl = false;
        Collection $this$toTypedArray$iv = string.split(charSequence, n);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] parts = stringArray;
        result.setIV(Companion.base64Decode(parts[0]));
        result.setEncryptedData(Companion.base64Decode(parts[1]));
        if (parts.length > 2) {
            result.setMac(Companion.base64Decode(parts[2]));
        }
        return result;
    }

    public final void loadKeyStore() throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        KeyStore keyStore = KeyStore.getInstance(this.KEYSTORE_PROVIDER);
        Intrinsics.checkExpressionValueIsNotNull((Object)keyStore, (String)"KeyStore.getInstance(KEYSTORE_PROVIDER)");
        this.mStore = keyStore;
        Logger.appendTag("flybits_encryption").e("loadKeyStore");
        KeyStore keyStore2 = this.mStore;
        if (keyStore2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mStore");
        }
        keyStore2.load(null);
    }

    @NotNull
    public final byte[] getIV() throws UnsupportedEncodingException {
        byte[] iv = null;
        iv = !this.isCompatMode ? new byte[this.IV_LENGTH] : new byte[this.COMPAT_IV_LENGTH];
        SecureRandom rng = new SecureRandom();
        rng.nextBytes(iv);
        return iv;
    }

    @TargetApi(value=19)
    @NotNull
    public final Cipher getCipherAES(@Nullable byte[] IV, boolean modeEncrypt) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException {
        Cipher cipher = Cipher.getInstance(this.AES_CIPHER);
        Logger.appendTag("flybits_encryption").e(String.valueOf(this.aesKey));
        cipher.init(modeEncrypt ? 1 : 2, (Key)this.aesKey, new GCMParameterSpec(this.GCM_TAG_LENGTH, IV));
        Cipher cipher2 = cipher;
        Intrinsics.checkExpressionValueIsNotNull((Object)cipher2, (String)"cipher");
        return cipher2;
    }

    @TargetApi(value=19)
    @NotNull
    public final EncryptedData encryptAES(@Nullable byte[] bytes, @Nullable byte[] IV) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException, UnsupportedEncodingException {
        Cipher cipher = this.getCipherAES(IV, true);
        EncryptedData result = new EncryptedData();
        result.setIV(cipher.getIV());
        result.setEncryptedData(cipher.doFinal(bytes));
        return result;
    }

    @TargetApi(value=19)
    @NotNull
    public final byte[] decryptAES(@NotNull EncryptedData encryptedData) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException, UnsupportedEncodingException {
        Intrinsics.checkParameterIsNotNull((Object)encryptedData, (String)"encryptedData");
        Cipher cipher = this.getCipherAES(encryptedData.getIV(), false);
        byte[] byArray = cipher.doFinal(encryptedData.getEncryptedData());
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"cipher.doFinal(encryptedData.encryptedData)");
        return byArray;
    }

    @NotNull
    public final Cipher getCipherAESCompat(@Nullable byte[] IV, boolean modeEncrypt) throws NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException, InvalidKeyException {
        Cipher c = Cipher.getInstance(this.AES_CIPHER_COMPAT, this.BOUNCY_CASTLE_PROVIDER);
        c.init(modeEncrypt ? 1 : 2, (Key)this.aesKey, new IvParameterSpec(IV));
        Cipher cipher = c;
        Intrinsics.checkExpressionValueIsNotNull((Object)cipher, (String)"c");
        return cipher;
    }

    @NotNull
    public final EncryptedData encryptAESCompat(@Nullable byte[] bytes, @Nullable byte[] IV) throws NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException, UnsupportedEncodingException, InvalidAlgorithmParameterException {
        Cipher c = this.getCipherAESCompat(IV, true);
        EncryptedData result = new EncryptedData();
        result.setIV(c.getIV());
        result.setEncryptedData(c.doFinal(bytes));
        result.setMac(this.computeMac(result.getDataForMacComputation()));
        return result;
    }

    @NotNull
    public final byte[] decryptAESCompat(@NotNull EncryptedData encryptedData) throws UnsupportedEncodingException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, NoSuchPaddingException, InvalidAlgorithmParameterException, BadPaddingException, IllegalBlockSizeException, InvalidMacException {
        Intrinsics.checkParameterIsNotNull((Object)encryptedData, (String)"encryptedData");
        if (!this.verifyMac(encryptedData.getMac(), encryptedData.getDataForMacComputation())) {
            throw (Throwable)new InvalidMacException();
        }
        Cipher c = this.getCipherAESCompat(encryptedData.getIV(), false);
        byte[] byArray = c.doFinal(encryptedData.getEncryptedData());
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"c.doFinal(encryptedData.encryptedData)");
        return byArray;
    }

    public final void loadKey(@NotNull SharedPreferences prefStore) throws KeyStoreException, UnrecoverableEntryException, NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException, InvalidKeyException, IOException {
        Intrinsics.checkParameterIsNotNull((Object)prefStore, (String)"prefStore");
        Logger.appendTag("flybits_encryption").i("laodKey");
        if (!this.isCompatMode) {
            KeyStore keyStore = this.mStore;
            if (keyStore == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mStore");
            }
            if (keyStore.containsAlias(this.AES_KEY_ALIAS)) {
                KeyStore keyStore2 = this.mStore;
                if (keyStore2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mStore");
                }
                KeyStore.Entry entry = keyStore2.getEntry(this.AES_KEY_ALIAS, null);
                if (entry == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.security.KeyStore.SecretKeyEntry");
                }
                KeyStore.SecretKeyEntry entry2 = (KeyStore.SecretKeyEntry)entry;
                this.aesKey = entry2.getSecretKey();
            }
        } else {
            this.aesKey = this.getFallbackAESKey(prefStore);
            this.macKey = this.getMacKey(prefStore);
        }
    }

    public final boolean generateKey(@Nullable Context context, @Nullable byte[] seed, @NotNull SharedPreferences prefStore) throws KeyStoreException, NoSuchProviderException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, UnrecoverableEntryException, NoSuchPaddingException, InvalidKeyException, IOException {
        Intrinsics.checkParameterIsNotNull((Object)prefStore, (String)"prefStore");
        boolean keyGenerated = false;
        if (!this.isCompatMode) {
            keyGenerated = this.generateAESKey(seed);
        } else {
            keyGenerated = this.generateRSAKeys(context, seed);
            this.loadRSAKeys();
            keyGenerated = this.generateFallbackAESKey(prefStore, seed) || keyGenerated;
            keyGenerated = this.generateMacKey(prefStore, seed) || keyGenerated;
        }
        return keyGenerated;
    }

    @TargetApi(value=23)
    public final boolean generateAESKey(@Nullable byte[] seed) throws KeyStoreException, NoSuchProviderException, NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        Logger.appendTag("flybits_encryption").e(this.AES_KEY_ALIAS);
        KeyStore keyStore = this.mStore;
        if (keyStore == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mStore");
        }
        if (!keyStore.containsAlias(this.AES_KEY_ALIAS)) {
            KeyGenerator keyGen = KeyGenerator.getInstance(KEY_ALGORITHM_AES, this.KEYSTORE_PROVIDER);
            Logger.appendTag("flybits_encryption").e("creating a keystore");
            KeyGenParameterSpec keyGenParameterSpec = new KeyGenParameterSpec.Builder(this.AES_KEY_ALIAS, 3).setCertificateSubject(new X500Principal(this.x500_PRINCIPAL)).setCertificateSerialNumber(BigInteger.ONE).setKeySize(this.AES_BIT_LENGTH).setBlockModes(new String[]{BLOCK_MODE_GCM}).setEncryptionPaddings(new String[]{ENCRYPTION_PADDING_NONE}).setRandomizedEncryptionRequired(false).build();
            Intrinsics.checkExpressionValueIsNotNull((Object)keyGenParameterSpec, (String)"KeyGenParameterSpec.Buil\u2026\n                .build()");
            KeyGenParameterSpec spec = keyGenParameterSpec;
            if (seed != null && seed.length > 0) {
                SecureRandom random = new SecureRandom(seed);
                keyGen.init((AlgorithmParameterSpec)spec, random);
            } else {
                keyGen.init((AlgorithmParameterSpec)spec);
            }
            keyGen.generateKey();
            return true;
        }
        return false;
    }

    public final boolean generateFallbackAESKey(@NotNull SharedPreferences prefStore, @Nullable byte[] seed) throws IOException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, KeyStoreException, NoSuchProviderException, UnrecoverableEntryException {
        Intrinsics.checkParameterIsNotNull((Object)prefStore, (String)"prefStore");
        String key = Companion.getHashed(this.AES_KEY_ALIAS);
        if (!prefStore.contains(key)) {
            SecretKey sKey;
            KeyGenerator keyGen = KeyGenerator.getInstance(KEY_ALGORITHM_AES);
            if (seed != null && seed.length > 0) {
                SecureRandom random = new SecureRandom(seed);
                keyGen.init(this.AES_BIT_LENGTH, random);
            } else {
                keyGen.init(this.AES_BIT_LENGTH);
            }
            SecretKey secretKey = sKey = keyGen.generateKey();
            Intrinsics.checkExpressionValueIsNotNull((Object)secretKey, (String)"sKey");
            byte[] byArray = secretKey.getEncoded();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"sKey.encoded");
            byte[] shiftedEncodedKey = this.xorWithKey(byArray, this.SHIFTING_KEY);
            byte[] encryptedData = this.RSAEncrypt(shiftedEncodedKey);
            String AESKey = Companion.base64Encode(encryptedData);
            boolean result = prefStore.edit().putString(key, AESKey).commit();
            String isCompatKey = Companion.getHashed(this.IS_COMPAT_MODE_KEY_ALIAS);
            prefStore.edit().putBoolean(isCompatKey, true).apply();
            return result;
        }
        return false;
    }

    public final boolean generateMacKey(@NotNull SharedPreferences prefStore, @Nullable byte[] seed) throws NoSuchPaddingException, InvalidKeyException, NoSuchAlgorithmException, KeyStoreException, NoSuchProviderException, UnrecoverableEntryException, IOException {
        Intrinsics.checkParameterIsNotNull((Object)prefStore, (String)"prefStore");
        String key = Companion.getHashed(this.MAC_KEY_ALIAS);
        if (!prefStore.contains(key)) {
            byte[] randomBytes = new byte[this.MAC_BIT_LENGTH / 8];
            SecureRandom rng = null;
            rng = seed != null && seed.length > 0 ? new SecureRandom(seed) : new SecureRandom();
            rng.nextBytes(randomBytes);
            byte[] encryptedKey = this.RSAEncrypt(randomBytes);
            String macKey = Companion.base64Encode(encryptedKey);
            return prefStore.edit().putString(key, macKey).commit();
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final byte[] xorWithKey(byte[] a, byte[] key) {
        if (key == null || key.length == 0) {
            return a;
        }
        byte[] out = new byte[a.length];
        int n = 0;
        int n2 = a.length;
        while (n < n2) {
            byte by;
            void i;
            byte by2 = a[i];
            byte by3 = key[i % key.length];
            void var10_10 = i++;
            byte[] byArray = out;
            boolean bl = false;
            byArray[var10_10] = by = (byte)(by2 ^ by3);
        }
        return out;
    }

    @Nullable
    public final SecretKey getFallbackAESKey(@NotNull SharedPreferences prefStore) throws IOException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, NoSuchPaddingException {
        Intrinsics.checkParameterIsNotNull((Object)prefStore, (String)"prefStore");
        String key = Companion.getHashed(this.AES_KEY_ALIAS);
        String base64Value = prefStore.getString(key, null);
        if (base64Value != null) {
            byte[] encryptedData = Companion.base64Decode(base64Value);
            byte[] shiftedEncodedKey = this.RSADecrypt(encryptedData);
            byte[] keyData = this.xorWithKey(shiftedEncodedKey, this.SHIFTING_KEY);
            return new SecretKeySpec(keyData, KEY_ALGORITHM_AES);
        }
        return null;
    }

    @Nullable
    public final SecretKey getMacKey(@Nullable SharedPreferences prefStore) throws IOException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, NoSuchPaddingException {
        String base64;
        String key = Companion.getHashed(this.MAC_KEY_ALIAS);
        SharedPreferences sharedPreferences = prefStore;
        String string = base64 = sharedPreferences != null ? sharedPreferences.getString(key, null) : null;
        if (base64 != null) {
            byte[] encryptedKey = Companion.base64Decode(base64);
            byte[] keyData = this.RSADecrypt(encryptedKey);
            return new SecretKeySpec(keyData, this.MAC_CIPHER);
        }
        return null;
    }

    public final void loadRSAKeys() throws KeyStoreException, UnrecoverableEntryException, NoSuchAlgorithmException {
        KeyStore keyStore = this.mStore;
        if (keyStore == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mStore");
        }
        if (keyStore.containsAlias(this.RSA_KEY_ALIAS)) {
            KeyStore keyStore2 = this.mStore;
            if (keyStore2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mStore");
            }
            if (keyStore2.entryInstanceOf(this.RSA_KEY_ALIAS, KeyStore.PrivateKeyEntry.class)) {
                KeyStore keyStore3 = this.mStore;
                if (keyStore3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mStore");
                }
                KeyStore.Entry entry = keyStore3.getEntry(this.RSA_KEY_ALIAS, null);
                if (entry == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.security.KeyStore.PrivateKeyEntry");
                }
                KeyStore.PrivateKeyEntry entry2 = (KeyStore.PrivateKeyEntry)entry;
                Certificate certificate = entry2.getCertificate();
                Intrinsics.checkExpressionValueIsNotNull((Object)certificate, (String)"entry.certificate");
                PublicKey publicKey = certificate.getPublicKey();
                if (publicKey == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.security.interfaces.RSAPublicKey");
                }
                this.publicKey = (RSAPublicKey)publicKey;
                PrivateKey privateKey = entry2.getPrivateKey();
                if (privateKey == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.security.interfaces.RSAPrivateKey");
                }
                this.privateKey = (RSAPrivateKey)privateKey;
            }
        }
    }

    @SuppressLint(value={"WrongConstant"})
    public final boolean generateRSAKeys(@Nullable Context context, @Nullable byte[] seed) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, KeyStoreException {
        if (context == null) {
            return false;
        }
        KeyStore keyStore = this.mStore;
        if (keyStore == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mStore");
        }
        if (!keyStore.containsAlias(this.RSA_KEY_ALIAS)) {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance(KEY_ALGORITHM_RSA, this.KEYSTORE_PROVIDER);
            KeyPairGeneratorSpec spec = null;
            Calendar start = Calendar.getInstance();
            start.add(11, -26);
            Calendar end = Calendar.getInstance();
            end.add(1, 100);
            KeyPairGeneratorSpec.Builder builder = new KeyPairGeneratorSpec.Builder(context).setAlias(this.RSA_KEY_ALIAS).setKeySize(this.RSA_BIT_LENGTH).setKeyType(KEY_ALGORITHM_RSA).setSerialNumber(BigInteger.ONE).setSubject(new X500Principal(this.x500_PRINCIPAL));
            Calendar calendar = start;
            Intrinsics.checkExpressionValueIsNotNull((Object)calendar, (String)"start");
            KeyPairGeneratorSpec.Builder builder2 = builder.setStartDate(calendar.getTime());
            Calendar calendar2 = end;
            Intrinsics.checkExpressionValueIsNotNull((Object)calendar2, (String)"end");
            KeyPairGeneratorSpec keyPairGeneratorSpec = builder2.setEndDate(calendar2.getTime()).build();
            Intrinsics.checkExpressionValueIsNotNull((Object)keyPairGeneratorSpec, (String)"KeyPairGeneratorSpec.Bui\u2026                 .build()");
            spec = keyPairGeneratorSpec;
            if (seed != null && seed.length > 0) {
                SecureRandom random = new SecureRandom(seed);
                keyGen.initialize((AlgorithmParameterSpec)spec, random);
            } else {
                keyGen.initialize((AlgorithmParameterSpec)spec);
            }
            keyGen.generateKeyPair();
            return true;
        }
        return false;
    }

    @NotNull
    public final byte[] computeMac(@Nullable byte[] data) throws NoSuchAlgorithmException, InvalidKeyException {
        Mac HmacSha256 = Mac.getInstance(this.MAC_CIPHER);
        HmacSha256.init(this.macKey);
        byte[] byArray = HmacSha256.doFinal(data);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"HmacSha256.doFinal(data)");
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean verifyMac(@Nullable byte[] mac, @Nullable byte[] data) throws InvalidKeyException, NoSuchAlgorithmException {
        if (mac != null && data != null) {
            byte[] actualMac = this.computeMac(data);
            if (actualMac.length != mac.length) {
                return false;
            }
            int result = 0;
            int n = 0;
            int n2 = actualMac.length;
            while (n < n2) {
                void i;
                byte by = actualMac[i];
                byte by2 = mac[i];
                int n3 = result;
                boolean bl = false;
                byte by3 = (byte)(by ^ by2);
                result = n3 | by3;
                ++i;
            }
            return result == 0;
        }
        return false;
    }

    @NotNull
    public final byte[] RSAEncrypt(@Nullable byte[] bytes) throws KeyStoreException, UnrecoverableEntryException, NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidKeyException, IOException {
        Cipher cipher = Cipher.getInstance(this.RSA_CIPHER, this.SSL_PROVIDER);
        Logger.appendTag("flybits_encryption").e("RSAEncrypt");
        cipher.init(1, this.publicKey);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        CipherOutputStream cipherOutputStream = new CipherOutputStream(outputStream, cipher);
        cipherOutputStream.write(bytes);
        cipherOutputStream.close();
        byte[] byArray = outputStream.toByteArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"outputStream.toByteArray()");
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final byte[] RSADecrypt(@Nullable byte[] bytes) throws NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, IOException {
        int n;
        int n2;
        Cipher cipher = Cipher.getInstance(this.RSA_CIPHER, this.SSL_PROVIDER);
        Logger.appendTag("flybits_encryption").e("RSADecrypt");
        cipher.init(2, this.privateKey);
        CipherInputStream cipherInputStream = new CipherInputStream(new ByteArrayInputStream(bytes), cipher);
        ArrayList<Byte> values = new ArrayList<Byte>();
        Ref.IntRef nextByte = new Ref.IntRef();
        while (true) {
            int n3 = cipherInputStream.read();
            n2 = 0;
            n = 0;
            int it = n3;
            boolean bl = false;
            nextByte.element = it;
            if (n3 == -1) break;
            values.add((byte)nextByte.element);
        }
        byte[] dbytes = new byte[values.size()];
        n2 = 0;
        n = dbytes.length;
        while (n2 < n) {
            void i;
            Object e = values.get((int)i);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"values[i]");
            dbytes[i] = ((Number)e).byteValue();
            ++i;
        }
        cipherInputStream.close();
        return dbytes;
    }

    public EncryptionManager(@Nullable Context context, @NotNull SharedPreferences prefStore, @Nullable String keyAliasPrefix, @Nullable byte[] bitShiftingKey, @Nullable SecuredPreferenceStore.KeyStoreRecoveryNotifier recoveryHandler) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)prefStore, (String)"prefStore");
        this.RSA_BIT_LENGTH = 2048;
        this.AES_BIT_LENGTH = 256;
        this.MAC_BIT_LENGTH = 256;
        this.GCM_TAG_LENGTH = 128;
        this.COMPAT_IV_LENGTH = 16;
        this.IV_LENGTH = 12;
        this.KEYSTORE_PROVIDER = "AndroidKeyStore";
        this.SSL_PROVIDER = "AndroidOpenSSL";
        this.BOUNCY_CASTLE_PROVIDER = "BC";
        this.DELIMITER = "]";
        this.RSA_CIPHER = "RSA/ECB/PKCS1Padding";
        this.AES_CIPHER = "AES/GCM/NoPadding";
        this.AES_CIPHER_COMPAT = "AES/CBC/PKCS7Padding";
        this.MAC_CIPHER = MAC_ALGORITHM_HMAC_SHA256;
        this.x500_PRINCIPAL = "CN = Flybits, O = Flybits Mobile";
        String keyAliasPrefix2 = keyAliasPrefix;
        this.SHIFTING_KEY = bitShiftingKey;
        keyAliasPrefix2 = prefStore.getString(Companion.getHashed(OVERRIDING_KEY_ALIAS_PREFIX_NAME), keyAliasPrefix2);
        String string2 = keyAliasPrefix2;
        if (string2 == null) {
            string2 = DEFAULT_KEY_ALIAS_PREFIX;
        }
        this.mKeyAliasPrefix = string2;
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string3 = "%s_%s";
        Object[] objectArray = new Object[]{this.mKeyAliasPrefix, IS_COMPAT_MODE_KEY_ALIAS_NAME};
        EncryptionManager encryptionManager2 = this;
        boolean bl = false;
        String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"java.lang.String.format(format, *args)");
        encryptionManager2.IS_COMPAT_MODE_KEY_ALIAS = string = string4;
        stringCompanionObject = StringCompanionObject.INSTANCE;
        string3 = "%s_%s";
        objectArray = new Object[]{this.mKeyAliasPrefix, RSA_KEY_ALIAS_NAME};
        encryptionManager2 = this;
        bl = false;
        String string5 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"java.lang.String.format(format, *args)");
        encryptionManager2.RSA_KEY_ALIAS = string = string5;
        stringCompanionObject = StringCompanionObject.INSTANCE;
        string3 = "%s_%s";
        objectArray = new Object[]{this.mKeyAliasPrefix, AES_KEY_ALIAS_NAME};
        encryptionManager2 = this;
        bl = false;
        String string6 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"java.lang.String.format(format, *args)");
        encryptionManager2.AES_KEY_ALIAS = string = string6;
        stringCompanionObject = StringCompanionObject.INSTANCE;
        string3 = "%s_%s";
        objectArray = new Object[]{this.mKeyAliasPrefix, MAC_KEY_ALIAS_NAME};
        encryptionManager2 = this;
        bl = false;
        String string7 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"java.lang.String.format(format, *args)");
        encryptionManager2.MAC_KEY_ALIAS = string = string7;
        String isCompatKey = Companion.getHashed(this.IS_COMPAT_MODE_KEY_ALIAS);
        this.isCompatMode = prefStore.getBoolean(isCompatKey, Build.VERSION.SDK_INT < 23);
        this.mRecoveryHandler = recoveryHandler;
        this.mContext = context;
        this.mPrefs = prefStore;
        this.loadKeyStore();
        boolean tryAgain = false;
        try {
            this.setup(context, prefStore, bitShiftingKey);
        }
        catch (Exception ex) {
            if (!this.isRecoverableError(ex)) {
                throw (Throwable)ex;
            }
            tryAgain = this.tryRecovery(ex);
        }
        if (tryAgain) {
            this.setup(context, prefStore, bitShiftingKey);
        }
    }

    @Deprecated(message="Use the full constructor for better security on older versions of Android\n      ")
    public EncryptionManager(@Nullable Context context, @NotNull SharedPreferences prefStore, @Nullable SecuredPreferenceStore.KeyStoreRecoveryNotifier recoveryNotifier) {
        Intrinsics.checkParameterIsNotNull((Object)prefStore, (String)"prefStore");
        this(context, prefStore, null, null, recoveryNotifier);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u000e\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B%\b\u0016\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0007R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\tR\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\t\"\u0004\b\u000f\u0010\u000bR\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\t\"\u0004\b\u0011\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lcom/flybits/commons/library/encryption/EncryptionManager$EncryptedData;", "", "()V", "IV", "", "encryptedData", "mac", "([B[B[B)V", "getIV", "()[B", "setIV", "([B)V", "dataForMacComputation", "getDataForMacComputation", "getEncryptedData", "setEncryptedData", "getMac", "setMac", "commons_release"})
    public static final class EncryptedData {
        @Nullable
        private byte[] IV;
        @Nullable
        private byte[] encryptedData;
        @Nullable
        private byte[] mac;

        @Nullable
        public final byte[] getIV() {
            return this.IV;
        }

        public final void setIV(@Nullable byte[] byArray) {
            this.IV = byArray;
        }

        @Nullable
        public final byte[] getEncryptedData() {
            return this.encryptedData;
        }

        public final void setEncryptedData(@Nullable byte[] byArray) {
            this.encryptedData = byArray;
        }

        @Nullable
        public final byte[] getMac() {
            return this.mac;
        }

        public final void setMac(@Nullable byte[] byArray) {
            this.mac = byArray;
        }

        @NotNull
        public final byte[] getDataForMacComputation() {
            if (this.IV == null || this.encryptedData == null) {
                Logger.appendTag("flybits_encryption").e("dataForMacComputation with empty data");
                return new byte[0];
            }
            if (this.IV == null) {
                Intrinsics.throwNpe();
            }
            int n = this.IV.length;
            if (this.encryptedData == null) {
                Intrinsics.throwNpe();
            }
            byte[] combinedData = new byte[n + this.encryptedData.length];
            if (this.IV == null) {
                Intrinsics.throwNpe();
            }
            if (this.IV == null) {
                Intrinsics.throwNpe();
            }
            System.arraycopy(this.IV, 0, combinedData, 0, this.IV.length);
            if (this.encryptedData == null) {
                Intrinsics.throwNpe();
            }
            if (this.IV == null) {
                Intrinsics.throwNpe();
            }
            int n2 = this.IV.length;
            if (this.encryptedData == null) {
                Intrinsics.throwNpe();
            }
            System.arraycopy(this.encryptedData, 0, combinedData, n2, this.encryptedData.length);
            return combinedData;
        }

        public EncryptedData() {
            this.IV = null;
            this.encryptedData = null;
            this.mac = null;
        }

        public EncryptedData(@Nullable byte[] IV, @Nullable byte[] encryptedData, @Nullable byte[] mac) {
            this.IV = IV;
            this.encryptedData = encryptedData;
            this.mac = mac;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/flybits/commons/library/encryption/EncryptionManager$InvalidMacException;", "Ljava/security/GeneralSecurityException;", "(Lcom/flybits/commons/library/encryption/EncryptionManager;)V", "commons_release"})
    public final class InvalidMacException
    extends GeneralSecurityException {
        public InvalidMacException() {
            super("Invalid Mac, failed to verify integrity.");
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0010\u0012\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u0018\u001a\u00020\u00042\b\u0010\u0019\u001a\u0004\u0018\u00010\u0016J\u0010\u0010\u001a\u001a\u00020\u00042\b\u0010\u0017\u001a\u0004\u0018\u00010\u0004J\u000e\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/flybits/commons/library/encryption/EncryptionManager$Companion;", "", "()V", "AES_KEY_ALIAS_NAME", "", "BLOCK_MODE_CBC", "BLOCK_MODE_ECB", "BLOCK_MODE_GCM", "DEFAULT_CHARSET", "DEFAULT_KEY_ALIAS_PREFIX", "ENCRYPTION_PADDING_NONE", "ENCRYPTION_PADDING_OAEP", "ENCRYPTION_PADDING_PKCS7", "ENCRYPTION_PADDING_RSA_PKCS1", "IS_COMPAT_MODE_KEY_ALIAS_NAME", "KEY_ALGORITHM_AES", "KEY_ALGORITHM_RSA", "MAC_ALGORITHM_HMAC_SHA256", "MAC_KEY_ALIAS_NAME", "OVERRIDING_KEY_ALIAS_PREFIX_NAME", "RSA_KEY_ALIAS_NAME", "base64Decode", "", "text", "base64Encode", "data", "getHashed", "toHex", "commons_release"})
    public static final class Companion {
        @NotNull
        public final String getHashed(@Nullable String text) throws NoSuchAlgorithmException, UnsupportedEncodingException {
            Object object;
            CharSequence charSequence = text;
            boolean bl = false;
            boolean bl2 = false;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                return "";
            }
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            String string = text;
            Object object2 = EncryptionManager.DEFAULT_CHARSET;
            MessageDigest messageDigest = digest;
            boolean bl3 = false;
            Charset charset = Charset.forName((String)object2);
            Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"Charset.forName(charsetName)");
            object2 = object = charset;
            bl3 = false;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = string2.getBytes((Charset)object2);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            object = byArray;
            byte[] result = messageDigest.digest((byte[])object);
            Intrinsics.checkExpressionValueIsNotNull((Object)result, (String)"result");
            return this.toHex(result);
        }

        @NotNull
        public final String toHex(@NotNull byte[] data) {
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            StringBuilder sb = new StringBuilder();
            for (byte b : data) {
                String string;
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string2 = "%02X";
                Object[] objectArray = new Object[]{b};
                StringBuilder stringBuilder = sb;
                boolean bl = false;
                Intrinsics.checkExpressionValueIsNotNull((Object)String.format(string2, Arrays.copyOf(objectArray, objectArray.length)), (String)"java.lang.String.format(format, *args)");
                stringBuilder.append(string);
            }
            String string = sb.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
            return string;
        }

        @NotNull
        public final String base64Encode(@Nullable byte[] data) {
            String string = Base64.encodeToString((byte[])data, (int)2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Base64.encodeToString(data, Base64.NO_WRAP)");
            return string;
        }

        @NotNull
        public final byte[] base64Decode(@Nullable String text) {
            byte[] byArray = Base64.decode((String)text, (int)2);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"Base64.decode(text, Base64.NO_WRAP)");
            return byArray;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

