package com.flybits.commons.library.exceptions;


/**
 *  The {@code FlybitsDisabledException} is thrown when the SDK requests information from the
 *  Flybits core but the Flybits core is not currently active. This exception should be initiated
 *  very rarely by the SDK, however, in most cases it is the result of the Flybits Core being down
 *  for maintenance. This downtime should be very short, nonetheless, application developers may
 *  want display information differently if this exception is thrown.
 *
 *  @since 1.0.0
 */
public class FlybitsDisabledException extends FlybitsException {

    /**
     * Constructs a new {@code FlybitsDisabledException} that includes the current stack trace.
     */
    public FlybitsDisabledException(){
        super();
    }

    /**
     * Constructs a new {@code FlybitsDisabledException} with the current stack trace and the specified
     * detail message.
     *
     * @param message the detail message for this exception.
     */
    public FlybitsDisabledException(String message) {
        super(message);
    }

    /**
     * Constructs a new {@code FlybitsDisabledException} with the current stack trace and the specified
     * cause.
     *
     * @param throwable the cause of this exception.
     */
    public FlybitsDisabledException(Throwable throwable){
        super(throwable);
    }

    /**
     * Constructs a new {@code FlybitsDisabledException} with the current stack trace,
     * the specified detail message and the specified cause.
     *
     * @param detailMessage the detail message for this exception.
     * @param throwable the cause of this exception.
     */
    public FlybitsDisabledException(String detailMessage, Throwable throwable){
        super(detailMessage, throwable);
    }
}