/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.analytics;

import android.content.Context;
import android.util.Log;
import androidx.work.Constraints;
import androidx.work.ExistingPeriodicWorkPolicy;
import androidx.work.NetworkType;
import androidx.work.PeriodicWorkRequest;
import androidx.work.WorkManager;
import androidx.work.WorkRequest;
import com.flybits.commons.library.analytics.Analytics;
import com.flybits.commons.library.analytics.AnalyticsWorker;
import com.flybits.commons.library.api.FlyAway;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.http.RequestStatus;
import com.flybits.commons.library.logging.Displayer;
import com.flybits.commons.library.logging.Logger;
import com.flybits.commons.library.models.CtxData;
import com.flybits.commons.library.models.internal.Result;
import com.flybits.internal.db.CommonsDatabase;
import com.flybits.internal.db.CtxDataDAO;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 (2\u00020\u0001:\u0002()B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\u000fH\u0002J\u0006\u0010\u0011\u001a\u00020\u000fJ\u001a\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0006\u0010\u0016\u001a\u00020\u000fJL\u0010\u0017\u001a\u00020\u000f2B\b\u0002\u0010\u0018\u001a<\u0012\u0013\u0012\u00110\u0013\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001c\u0012\u001b\u0012\u0019\u0018\u00010\u001dj\u0004\u0018\u0001`\u001e\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001f\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u0019H\u0002JT\u0010\u0017\u001a\u00020\u000f2B\b\u0002\u0010\u0018\u001a<\u0012\u0013\u0012\u00110\u0013\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001c\u0012\u001b\u0012\u0019\u0018\u00010\u001dj\u0004\u0018\u0001`\u001e\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001f\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u00192\b\b\u0002\u0010 \u001a\u00020\u0013J\b\u0010!\u001a\u00020\u000fH\u0002J\b\u0010\"\u001a\u00020\u000fH\u0002J\u0006\u0010#\u001a\u00020\u000fJ\u0010\u0010$\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020&H\u0004J\f\u0010'\u001a\u00020\u0015*\u00020&H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/flybits/commons/library/analytics/Analytics;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "CTX_DATA_ENDPOINT", "", "TAG_LOGGING", "UPLOAD_INTERVAL_METERED", "", "UPLOAD_INTERVAL_UNMETERED", "ctxDataDAO", "Lcom/flybits/internal/db/CtxDataDAO;", "kotlin.jvm.PlatformType", "cancelMeteredWork", "", "cancelUnmeteredWork", "cancelWorkers", "checkIfExists", "", "ctxData", "Lcom/flybits/commons/library/models/CtxData;", "destroy", "flush", "callback", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "success", "Ljava/lang/Exception;", "Lkotlin/Exception;", "exception", "async", "scheduleMeteredWorker", "scheduleUnmeteredWorker", "scheduleWorkers", "track", "event", "Lcom/flybits/commons/library/analytics/Analytics$Event;", "toCtxData", "Companion", "Event", "commons_release"})
public class Analytics {
    private final String TAG_LOGGING = "Analytics";
    private final long UPLOAD_INTERVAL_METERED = 60L;
    private final long UPLOAD_INTERVAL_UNMETERED = 20L;
    private final String CTX_DATA_ENDPOINT = "/context/ctxdata";
    private final CtxDataDAO ctxDataDAO;
    private final Context context;
    @NotNull
    public static final String TAG_METERED_WORK = "com.flybits.commons.library.analytics.meteredWork";
    @NotNull
    public static final String TAG_UNMETERED_WORK = "com.flybits.commons.library.analytics.unmeteredWork";
    public static final Companion Companion = new Companion(null);

    private final CtxData toCtxData(@NotNull Event $this$toCtxData) {
        JSONObject analyticsJson = new JSONObject();
        analyticsJson.put("dataTypeID", (Object)("ctx.flybits." + $this$toCtxData.getAnalyticsScope()));
        JSONObject valueJson = new JSONObject();
        valueJson.put("query." + $this$toCtxData.getAction() + '.' + $this$toCtxData.getDataId(), true);
        analyticsJson.put("value", (Object)valueJson);
        analyticsJson.put("timestamp", $this$toCtxData.getTimestamp() / (long)1000);
        long l = $this$toCtxData.getTimestamp();
        String string = analyticsJson.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"analyticsJson.toString()");
        return new CtxData(0L, l, string, 1, null);
    }

    public final void flush(@Nullable Function2<? super Boolean, ? super Exception, Unit> callback, boolean async) throws FlybitsException {
        Logger.appendTag(this.TAG_LOGGING).i("Flushing analytics data");
        if (async) {
            Executors.newSingleThreadExecutor().execute(new Runnable(this, callback){
                final /* synthetic */ Analytics this$0;
                final /* synthetic */ Function2 $callback;

                public final void run() {
                    try {
                        Analytics.access$flush(this.this$0, this.$callback);
                    }
                    catch (Exception e) {
                        Function2 function2 = this.$callback;
                        if (function2 != null) {
                            Unit cfr_ignored_0 = (Unit)function2.invoke((Object)false, (Object)e);
                        }
                        Logger.appendTag(Analytics.access$getTAG_LOGGING$p(this.this$0)).e("Flushing analytics data failed", e);
                    }
                }
                {
                    this.this$0 = analytics;
                    this.$callback = function2;
                }
            });
        } else {
            this.flush(callback);
        }
    }

    public static /* synthetic */ void flush$default(Analytics analytics, Function2 function2, boolean bl, int n, Object object) throws FlybitsException {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: flush");
        }
        if ((n & 1) != 0) {
            function2 = null;
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        analytics.flush((Function2<? super Boolean, ? super Exception, Unit>)function2, bl);
    }

    private final void flush(Function2<? super Boolean, ? super Exception, Unit> callback) throws FlybitsException {
        CtxDataDAO ctxDataDAO = CommonsDatabase.getDatabase(this.context).ctxDataDAO();
        List<CtxData> ctxData = ctxDataDAO.getAll();
        if (!ctxData.isEmpty()) {
            Result result;
            Logger.appendTag(this.TAG_LOGGING).i("Flushing analytics data - Non-Empty list");
            String body2 = CollectionsKt.joinToString$default((Iterable)ctxData, (CharSequence)",", (CharSequence)"[", (CharSequence)"]", (int)0, null, (Function1)flush.body.1.INSTANCE, (int)24, null);
            Result result2 = result = FlyAway.post(this.context, this.CTX_DATA_ENDPOINT, body2, null, "AnalyticsWorker.doWork", null);
            Intrinsics.checkExpressionValueIsNotNull(result2, (String)"result");
            if (result2.getStatus() == RequestStatus.COMPLETED) {
                ctxDataDAO.deleteMany((Collection<CtxData>)ctxData);
                Function2<? super Boolean, ? super Exception, Unit> function2 = callback;
                if (function2 != null) {
                    Unit cfr_ignored_0 = (Unit)function2.invoke((Object)true, null);
                }
                Logger.appendTag(this.TAG_LOGGING).i("Flushing analytics data success");
            } else {
                Function2<? super Boolean, ? super Exception, Unit> function2 = callback;
                if (function2 != null) {
                    Unit cfr_ignored_1 = (Unit)function2.invoke((Object)false, (Object)result.getException());
                }
                Displayer displayer = Logger.appendTag(this.TAG_LOGGING);
                FlybitsException flybitsException = result.getException();
                Intrinsics.checkExpressionValueIsNotNull((Object)flybitsException, (String)"result.exception");
                displayer.e("Flushing analytics data failed", flybitsException);
            }
        } else {
            Function2<? super Boolean, ? super Exception, Unit> function2 = callback;
            if (function2 != null) {
                Unit cfr_ignored_2 = (Unit)function2.invoke((Object)true, null);
            }
            Logger.appendTag(this.TAG_LOGGING).i("Flushing analytics data - Empty list, nothing sent");
        }
    }

    static /* synthetic */ void flush$default(Analytics analytics, Function2 function2, int n, Object object) throws FlybitsException {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: flush");
        }
        if ((n & 1) != 0) {
            function2 = null;
        }
        analytics.flush((Function2<? super Boolean, ? super Exception, Unit>)function2);
    }

    public final void scheduleWorkers() {
        this.scheduleMeteredWorker();
        this.scheduleUnmeteredWorker();
        Logger.appendTag(this.TAG_LOGGING).i("Analytics workers are scheduled");
    }

    public final void cancelWorkers() {
        this.cancelUnmeteredWork();
        this.cancelMeteredWork();
        Logger.appendTag(this.TAG_LOGGING).i("Analytics workers are cancelled");
    }

    public final void destroy() {
        this.cancelWorkers();
        Executors.newSingleThreadExecutor().execute(new Runnable(this){
            final /* synthetic */ Analytics this$0;

            public final void run() {
                Analytics.access$getCtxDataDAO$p(this.this$0).deleteAll();
                Logger.appendTag(Analytics.access$getTAG_LOGGING$p(this.this$0)).i("Ctxdata database in Commons cleared");
            }
            {
                this.this$0 = analytics;
            }
        });
    }

    private final void cancelUnmeteredWork() {
        WorkManager.getInstance().cancelUniqueWork(TAG_UNMETERED_WORK);
    }

    private final void cancelMeteredWork() {
        WorkManager.getInstance().cancelUniqueWork(TAG_METERED_WORK);
    }

    private final void scheduleMeteredWorker() {
        Constraints constraints = new Constraints.Builder().setRequiredNetworkType(NetworkType.METERED).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)constraints, (String)"Constraints.Builder()\n  \u2026\n                .build()");
        Constraints constraintsMetered = constraints;
        WorkRequest workRequest = ((PeriodicWorkRequest.Builder)((PeriodicWorkRequest.Builder)new PeriodicWorkRequest.Builder(AnalyticsWorker.class, this.UPLOAD_INTERVAL_METERED, TimeUnit.MINUTES).setConstraints(constraintsMetered)).addTag(TAG_METERED_WORK)).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)workRequest, (String)"PeriodicWorkRequest\n    \u2026\n                .build()");
        PeriodicWorkRequest workRequestMetered = (PeriodicWorkRequest)workRequest;
        WorkManager.getInstance().enqueueUniquePeriodicWork(TAG_METERED_WORK, ExistingPeriodicWorkPolicy.KEEP, workRequestMetered);
    }

    private final void scheduleUnmeteredWorker() {
        Constraints constraints = new Constraints.Builder().setRequiredNetworkType(NetworkType.UNMETERED).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)constraints, (String)"Constraints.Builder()\n  \u2026\n                .build()");
        Constraints constraintsMetered = constraints;
        WorkRequest workRequest = ((PeriodicWorkRequest.Builder)((PeriodicWorkRequest.Builder)new PeriodicWorkRequest.Builder(AnalyticsWorker.class, this.UPLOAD_INTERVAL_UNMETERED, TimeUnit.MINUTES).setConstraints(constraintsMetered)).addTag(TAG_UNMETERED_WORK)).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)workRequest, (String)"PeriodicWorkRequest\n    \u2026\n                .build()");
        PeriodicWorkRequest workRequestMetered = (PeriodicWorkRequest)workRequest;
        WorkManager.getInstance().enqueueUniquePeriodicWork(TAG_UNMETERED_WORK, ExistingPeriodicWorkPolicy.KEEP, workRequestMetered);
    }

    protected final void track(@NotNull Event event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        Executors.newSingleThreadExecutor().execute(new Runnable(this, event){
            final /* synthetic */ Analytics this$0;
            final /* synthetic */ Event $event;

            public final void run() {
                CtxData data;
                Logger.appendTag(Analytics.access$getTAG_LOGGING$p(this.this$0)).i("Received event: " + this.$event.getAnalyticsScope() + " - " + this.$event.getAction() + " - " + this.$event.getDataId());
                CtxData ctxData = data = Analytics.access$toCtxData(this.this$0, this.$event);
                Log.e((String)"abhijit1", (String)(ctxData != null ? ctxData.getValue() : null).toString());
                CtxDataDAO ctxDataDAO = Analytics.access$getCtxDataDAO$p(this.this$0);
                Intrinsics.checkExpressionValueIsNotNull((Object)ctxDataDAO, (String)"ctxDataDAO");
                if (Analytics.access$checkIfExists(this.this$0, data, ctxDataDAO)) {
                    CtxDataDAO ctxDataDAO2 = Analytics.access$getCtxDataDAO$p(this.this$0);
                    if (ctxDataDAO2 != null) {
                        ctxDataDAO2.insert(data);
                    }
                    Logger.appendTag("TAG_LOGGING").i("Recorded event: " + data.getId() + " - " + data.getValue());
                }
            }
            {
                this.this$0 = analytics;
                this.$event = event;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean checkIfExists(CtxData ctxData, CtxDataDAO ctxDataDAO) {
        Analytics analytics = this;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (analytics) {
            CtxData ctxData2;
            CtxData it;
            List<CtxData> dataFromCursor;
            boolean bl3 = false;
            List<CtxData> list = dataFromCursor = ctxDataDAO.getAll();
            boolean bl4 = false;
            boolean bl5 = false;
            List<CtxData> it2 = list;
            boolean bl6 = false;
            Iterable $this$forEach$iv = dataFromCursor;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            do {
                if (!iterator.hasNext()) {
                    return true;
                }
                Object element$iv = iterator.next();
                it = (CtxData)element$iv;
                boolean bl7 = false;
                ctxData2 = ctxData;
            } while (!Intrinsics.areEqual((Object)it.getValue(), (Object)String.valueOf(ctxData2 != null ? ctxData2.getValue() : null)));
            CtxData ctxData3 = ctxData;
            Log.e((String)"abhijit", (String)(it.getValue() + " / " + String.valueOf(ctxData3 != null ? ctxData3.getValue() : null)));
            return false;
        }
    }

    public Analytics(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        this.TAG_LOGGING = "Analytics";
        this.UPLOAD_INTERVAL_METERED = 60L;
        this.UPLOAD_INTERVAL_UNMETERED = 20L;
        this.CTX_DATA_ENDPOINT = "/context/ctxdata";
        this.ctxDataDAO = CommonsDatabase.getDatabase(this.context).ctxDataDAO();
    }

    public static final /* synthetic */ void access$flush(Analytics $this, Function2 callback) {
        $this.flush((Function2<? super Boolean, ? super Exception, Unit>)callback);
    }

    public static final /* synthetic */ String access$getTAG_LOGGING$p(Analytics $this) {
        return $this.TAG_LOGGING;
    }

    public static final /* synthetic */ CtxDataDAO access$getCtxDataDAO$p(Analytics $this) {
        return $this.ctxDataDAO;
    }

    public static final /* synthetic */ CtxData access$toCtxData(Analytics $this, Event $this$access_u24toCtxData) {
        return $this.toCtxData($this$access_u24toCtxData);
    }

    public static final /* synthetic */ boolean access$checkIfExists(Analytics $this, CtxData ctxData, CtxDataDAO ctxDataDAO) {
        return $this.checkIfExists(ctxData, ctxDataDAO);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J1\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lcom/flybits/commons/library/analytics/Analytics$Event;", "", "analyticsScope", "", "action", "dataId", "timestamp", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;J)V", "getAction", "()Ljava/lang/String;", "getAnalyticsScope", "getDataId", "getTimestamp", "()J", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "commons_release"})
    public static final class Event {
        @NotNull
        private final String analyticsScope;
        @NotNull
        private final String action;
        @NotNull
        private final String dataId;
        private final long timestamp;

        @NotNull
        public final String getAnalyticsScope() {
            return this.analyticsScope;
        }

        @NotNull
        public final String getAction() {
            return this.action;
        }

        @NotNull
        public final String getDataId() {
            return this.dataId;
        }

        public final long getTimestamp() {
            return this.timestamp;
        }

        public Event(@NotNull String analyticsScope, @NotNull String action, @NotNull String dataId, long timestamp) {
            Intrinsics.checkParameterIsNotNull((Object)analyticsScope, (String)"analyticsScope");
            Intrinsics.checkParameterIsNotNull((Object)action, (String)"action");
            Intrinsics.checkParameterIsNotNull((Object)dataId, (String)"dataId");
            this.analyticsScope = analyticsScope;
            this.action = action;
            this.dataId = dataId;
            this.timestamp = timestamp;
        }

        @NotNull
        public final String component1() {
            return this.analyticsScope;
        }

        @NotNull
        public final String component2() {
            return this.action;
        }

        @NotNull
        public final String component3() {
            return this.dataId;
        }

        public final long component4() {
            return this.timestamp;
        }

        @NotNull
        public final Event copy(@NotNull String analyticsScope, @NotNull String action, @NotNull String dataId, long timestamp) {
            Intrinsics.checkParameterIsNotNull((Object)analyticsScope, (String)"analyticsScope");
            Intrinsics.checkParameterIsNotNull((Object)action, (String)"action");
            Intrinsics.checkParameterIsNotNull((Object)dataId, (String)"dataId");
            return new Event(analyticsScope, action, dataId, timestamp);
        }

        public static /* synthetic */ Event copy$default(Event event, String string, String string2, String string3, long l, int n, Object object) {
            if ((n & 1) != 0) {
                string = event.analyticsScope;
            }
            if ((n & 2) != 0) {
                string2 = event.action;
            }
            if ((n & 4) != 0) {
                string3 = event.dataId;
            }
            if ((n & 8) != 0) {
                l = event.timestamp;
            }
            return event.copy(string, string2, string3, l);
        }

        @NotNull
        public String toString() {
            return "Event(analyticsScope=" + this.analyticsScope + ", action=" + this.action + ", dataId=" + this.dataId + ", timestamp=" + this.timestamp + ")";
        }

        public int hashCode() {
            String string = this.analyticsScope;
            String string2 = this.action;
            String string3 = this.dataId;
            return (((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0)) * 31 + Long.hashCode(this.timestamp);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Event)) break block3;
                    Event event = (Event)object;
                    if (!Intrinsics.areEqual((Object)this.analyticsScope, (Object)event.analyticsScope) || !Intrinsics.areEqual((Object)this.action, (Object)event.action) || !Intrinsics.areEqual((Object)this.dataId, (Object)event.dataId) || this.timestamp != event.timestamp) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/flybits/commons/library/analytics/Analytics$Companion;", "", "()V", "TAG_METERED_WORK", "", "TAG_UNMETERED_WORK", "commons_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

