package com.flybits.internal

import android.content.Context
import android.util.Log
import com.flybits.commons.library.logging.Logger
import com.flybits.commons.library.models.CtxData
import com.flybits.internal.db.CommonsDatabase
import com.flybits.internal.db.CtxDataDAO

class DeboucerAnalyticsReporting(var context: Context?, var ctxData: CtxData?) : Debounce() {

    private var ctxDataDAO = CommonsDatabase.getDatabase(context).ctxDataDAO()

    override fun getKey(): String {
        return "Analytics"
    }

    override fun doSomething() {
        ctxData?.let { ctxData ->
            Log.e("abhijit1",ctxData?.value.toString())
            if (checkIfExists(ctxData, ctxDataDAO)) {
                ctxDataDAO?.insert(ctxData)
                Logger.appendTag("TAG_LOGGING")
                    .i("Recorded event: ${ctxData.id} - ${ctxData.value}")
            }
        }
    }

    private fun checkIfExists(ctxData: CtxData?, ctxDataDAO: CtxDataDAO): Boolean {
        synchronized(this) {
            val dataFromCursor = ctxDataDAO.getAll()
            dataFromCursor.let {
                dataFromCursor.forEach {
                    if (it.value == ctxData?.value.toString()) {
                        Log.e("abhijit",it.value+ " / " + ctxData?.value.toString())
                        return false
                    }
                }
                return true
            }
        }
    }

    override fun equals(other: Any?): Boolean {
        if (this === other) return true

        if (other !is Debounce) {
            return false
        }

        val that = other as Debounce
        return that.key == key
    }

    override fun hashCode(): Int {
        return 88
    }
}