package com.flybits.commons.library.deserializations;

import com.flybits.commons.library.logging.Logger;
import com.flybits.commons.library.models.User;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import static com.flybits.commons.library.models.User.FIELD_EMAIL;
import static com.flybits.commons.library.models.User.FIELD_FIRST_NAME;
import static com.flybits.commons.library.models.User.FIELD_ID;
import static com.flybits.commons.library.models.User.FIELD_LAST_NAME;

public class DeserializeLogin extends IDeserializer<User> {
    private static final String CURRENT_DEVICE_ID = "currentDeviceId";
    private static final String IS_CONFIRMED = "isConfirmed";

    @Override
    public String toJson(User obj) {

        JSONObject object = new JSONObject();

        if (obj.getId() != null) {
            try {
                object.put(FIELD_ID, obj.getId());
            } catch (JSONException ex) {
            }
        }

        if (obj.getEmail() != null) {
            try {
                object.put(FIELD_EMAIL, obj.getEmail());
            } catch (JSONException ex) {
            }
        }

        if (obj.getDeviceID() != null) {
            try {
                object.put(CURRENT_DEVICE_ID, obj.getDeviceID());
            } catch (JSONException ex) {
            }
        }

        if (obj.getFirstName() != null) {
            try {
                object.put(FIELD_FIRST_NAME, obj.getFirstName());
            } catch (JSONException ex) {
            }
        }

        if (obj.getLastName() != null) {
            try {
                object.put(FIELD_LAST_NAME, obj.getLastName());
            } catch (JSONException ex) {
            }
        }
        try {
            object.put(IS_CONFIRMED, obj.isVerified());
        } catch (JSONException ex) {
        }

        try {
            object.put(User.FIELD_IS_OPTED_IN, obj.isOptedIn());
        } catch (JSONException e) {
        }

        try {
            object.put(User.FIELD_IS_ACTIVE, obj.isActive());
        } catch (JSONException e) {
        }

        return object.toString();
    }

    @Override
    public User fromJson(JSONObject jObj) {
        try {
            if (!jObj.isNull(FIELD_ID) && !jObj.isNull(FIELD_EMAIL) && !jObj.isNull(CURRENT_DEVICE_ID)) {

                String id = jObj.getString(FIELD_ID);
                String email = jObj.getString(FIELD_EMAIL);
                String deviceID = jObj.getString(CURRENT_DEVICE_ID);

                User user = new User(id, email, deviceID);
                if (!jObj.isNull(FIELD_FIRST_NAME) && !jObj.isNull(FIELD_LAST_NAME)) {
                    user.setName(jObj.getString(FIELD_FIRST_NAME), jObj.getString(FIELD_LAST_NAME));
                }
                if (!jObj.isNull(IS_CONFIRMED)) {
                    user.setIsVerified(jObj.getBoolean(IS_CONFIRMED));
                }
                if (jObj.has(User.FIELD_IS_OPTED_IN)) {
                    user.setOptedIn(jObj.getBoolean(User.FIELD_IS_OPTED_IN));
                } else {
                    user.setOptedIn(true);
                }
                if (jObj.has(User.FIELD_IS_ACTIVE)) {
                    user.setActive(jObj.getBoolean(User.FIELD_IS_ACTIVE));
                } else {
                    user.setActive(true);
                }

                return user;
            }
        } catch (JSONException e) {
            Logger.exception("DeserializeLogin.fromJson", e);
        }
        return null;
    }

    @Override
    public User fromJson(JSONArray jsonObject) {
        return null;
    }
}
