package com.flybits.commons.library.api.results.callbacks

/**
 * Callback used to indicate whether or not a network query that returns a single item was
 * successful or not.
 *
 * @param <T> The item type that is expected to be returned as a list.
 */
interface ObjectResultCallback<T> : BaseCallback {

    /**
     * Indicates that the request was successfully made.
     *
     * @param item The item that is expected to be returned.
     */
    fun onSuccess(item : T)
}