package com.flybits.commons.library.exceptions;

/**
 *  The {@code PermissionNotSetException} class is thrown whenever the application has not added a
 *  permission to the {@code AndroidManifest.xml} file that is needed to continue.
 *
 *  @since 1.0.0
 */
public class PermissionNotSetException extends RuntimeException {

    /**
     * Constructs an empty {@code PermissionNotSetException}.
     */
    public PermissionNotSetException(){}

    /**
     * Constructs a new {@code PermissionNotSetException} with a specified message indicating why
     * the exception was thrown.
     *
     * @param message the detail message for this exception.
     */
    public PermissionNotSetException(String message) {
        super(message);
    }

    /**
     * Constructs a new {@code PermissionNotSetException} with the cause of the exception.
     *
     * @param throwable the cause of this exception.
     */
    public PermissionNotSetException(Throwable throwable){
        super(throwable);
    }

    /**
     * Constructs a new {@code PermissionNotSetException} with the specified detail message and the
     * specified cause.
     *
     * @param detailMessage the detail message for this exception.
     * @param throwable the cause of this exception.
     */
    public PermissionNotSetException(String detailMessage, Throwable throwable){
        super(detailMessage, throwable);
    }
}