package com.flybits.commons.library

import android.content.Context
import android.util.Log
import com.flybits.commons.library.logging.Logger
import com.flybits.internal.db.CommonsDatabase
import devliving.online.securedpreferencestore.DefaultRecoveryHandler
import devliving.online.securedpreferencestore.SecuredPreferenceStore

/**
 * Factory object used for creating [SharedElements]. Depending on whether or not encryption
 * is supported on the device, [SecuredSharedElements] or [UnsecuredSharedElements] will
 * be returned by the [SharedElementsFactory.get] method.
 */
object SharedElementsFactory {

    @Volatile
    internal var savedInstance: SharedElements? = null

    //TODO Just so I understand, savedInstance have to be created
    fun get(context: Context) :SharedElements = savedInstance?:get(context,false)
    /**
     * Get instance of [SharedElements].
     *
     * @param context Context of the application.
     * @param fallbackToMemory when our SP encryption are not supported, keep the sensitive info oon in memory
     * @return [SecuredSharedElements] if encryption is supported. [UnsecuredSharedElements] otherwise.
     */
    fun get(context: Context, fallbackToMemory:Boolean = false): SharedElements {
        return savedInstance ?: synchronized(this) {
            val userDAO = CommonsDatabase.getDatabase(context).userDao()
            savedInstance ?:
                SharedElementsInMemory(context.getSharedPreferences(
                    SharedElements.FLYBITS_STORAGE_NEVER_EXIST, Context.MODE_PRIVATE
                ), userDAO).also { savedInstance = it }


        }
    }

}