/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.analytics;

import android.content.Context;
import androidx.work.ListenableWorker;
import androidx.work.Worker;
import androidx.work.WorkerParameters;
import com.flybits.commons.library.SharedElements;
import com.flybits.commons.library.SharedElementsFactory;
import com.flybits.commons.library.analytics.Analytics;
import com.flybits.commons.library.api.results.callbacks.BasicResultCallback;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.logging.Logger;
import com.flybits.commons.library.models.Device;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lcom/flybits/commons/library/analytics/AnalyticsWorker;", "Landroidx/work/Worker;", "context", "Landroid/content/Context;", "workerParameters", "Landroidx/work/WorkerParameters;", "(Landroid/content/Context;Landroidx/work/WorkerParameters;)V", "doWork", "Landroidx/work/ListenableWorker$Result;", "Companion", "commons_release"})
public final class AnalyticsWorker
extends Worker {
    private static final String TAG_LOGGING = "Analytics";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public ListenableWorker.Result doWork() {
        Context context = this.getApplicationContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"applicationContext");
        return Companion.doWork(context);
    }

    public AnalyticsWorker(@NotNull Context context, @NotNull WorkerParameters workerParameters) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)workerParameters, (String)"workerParameters");
        super(context, workerParameters);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/flybits/commons/library/analytics/AnalyticsWorker$Companion;", "", "()V", "TAG_LOGGING", "", "doWork", "Landroidx/work/ListenableWorker$Result;", "applicationContext", "Landroid/content/Context;", "commons_release"})
    public static final class Companion {
        @NotNull
        public final ListenableWorker.Result doWork(@NotNull Context applicationContext) {
            ListenableWorker.Result result;
            Intrinsics.checkParameterIsNotNull((Object)applicationContext, (String)"applicationContext");
            try {
                SharedElements sharedElements = SharedElementsFactory.INSTANCE.get(applicationContext);
                if (!sharedElements.getIsUserAgent()) {
                    Device device = new Device(null, null, null, null, 15, null);
                    device.setUserAgent(applicationContext, new BasicResultCallback(sharedElements){
                        final /* synthetic */ SharedElements $sharedElements;

                        public void onSuccess() {
                            this.$sharedElements.setUserAgent(true);
                        }

                        public void onException(@NotNull FlybitsException exception) {
                            Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
                            this.$sharedElements.setUserAgent(false);
                        }
                        {
                            this.$sharedElements = $captured_local_variable$0;
                        }
                    });
                }
                Analytics.flush$default(new Analytics(applicationContext), null, false, 3, null);
                Logger.appendTag(AnalyticsWorker.TAG_LOGGING).i("Analytics worker ran successfully");
                ListenableWorker.Result result2 = ListenableWorker.Result.success();
                Intrinsics.checkExpressionValueIsNotNull((Object)result2, (String)"Result.success()");
                result = result2;
            }
            catch (FlybitsException e) {
                Logger.appendTag(AnalyticsWorker.TAG_LOGGING).e("Analytics worker failed", e);
                ListenableWorker.Result result3 = ListenableWorker.Result.failure();
                Intrinsics.checkExpressionValueIsNotNull((Object)result3, (String)"Result.failure()");
                result = result3;
            }
            return result;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

