package com.flybits.commons.library.analytics

import android.content.Context
import androidx.work.Worker
import androidx.work.WorkerParameters
import com.flybits.commons.library.SharedElementsFactory
import com.flybits.commons.library.api.results.callbacks.BasicResultCallback
import com.flybits.commons.library.exceptions.FlybitsException
import com.flybits.commons.library.logging.Logger
import com.flybits.commons.library.models.Device

class AnalyticsWorker(context: Context, workerParameters: WorkerParameters) :
    Worker(context, workerParameters) {

    companion object {

        private const val TAG_LOGGING = "Analytics"
        fun doWork(applicationContext: Context): Result {
            return try {
                val sharedElements = SharedElementsFactory.get(applicationContext)
                if (!sharedElements.getIsUserAgent()) {
                    val device = Device()
                    device.setUserAgent(applicationContext, object : BasicResultCallback {
                        override fun onSuccess() {
                            sharedElements.setUserAgent(true)
                        }

                        override fun onException(exception: FlybitsException) {
                            sharedElements.setUserAgent(false)
                        }
                    })
                }

                Analytics(applicationContext).flush()
                Logger.appendTag(TAG_LOGGING).i("Analytics worker ran successfully")
                Result.success()
            } catch (e: FlybitsException) {
                Logger.appendTag(TAG_LOGGING).e("Analytics worker failed", e)
                Result.failure()
            }
        }
    }

    override fun doWork(): Result {
        return doWork(applicationContext)
    }
}