/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.api;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import com.flybits.commons.library.SharedElements;
import com.flybits.commons.library.SharedElementsFactory;
import com.flybits.commons.library.analytics.Analytics;
import com.flybits.commons.library.api.CustomerStatus;
import com.flybits.commons.library.api.FlyAway;
import com.flybits.commons.library.api.FlyJWT;
import com.flybits.commons.library.api.FlybitsScope;
import com.flybits.commons.library.api.Region;
import com.flybits.commons.library.api.ScopeOfficer;
import com.flybits.commons.library.api.idps.FlybitsIDP;
import com.flybits.commons.library.api.idps.HttpMethod;
import com.flybits.commons.library.api.idps.IDP;
import com.flybits.commons.library.api.results.BasicResult;
import com.flybits.commons.library.api.results.ConnectionResult;
import com.flybits.commons.library.api.results.ObjectResult;
import com.flybits.commons.library.api.results.callbacks.BasicResultCallback;
import com.flybits.commons.library.api.results.callbacks.ConnectionResultCallback;
import com.flybits.commons.library.api.results.callbacks.ObjectResultCallback;
import com.flybits.commons.library.api.results.callbacks.PagedResultCallback;
import com.flybits.commons.library.deserializations.DeserializeLogin;
import com.flybits.commons.library.deserializations.DeserializePagedResponse;
import com.flybits.commons.library.deserializations.DeserializeProject;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.exceptions.InvalidFlybitsManagerException;
import com.flybits.commons.library.exceptions.InvalidRegionException;
import com.flybits.commons.library.http.RequestStatus;
import com.flybits.commons.library.logging.Logger;
import com.flybits.commons.library.logging.VerbosityLevel;
import com.flybits.commons.library.models.Jwt;
import com.flybits.commons.library.models.Project;
import com.flybits.commons.library.models.User;
import com.flybits.commons.library.models.internal.Result;
import com.flybits.commons.library.models.results.ProjectsResult;
import com.flybits.commons.library.utils.ProjectParameters;
import com.flybits.internal.db.CommonsDatabase;
import com.flybits.internal.db.CtxDataDAO;
import com.flybits.internal.db.UserDAO;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class FlybitsManager {
    private static final String TAG_MANAGER = "Manager";
    public static final String AUTHENTICATION_API = "/sso/auth";
    private static final String PROJECTS_API = "/kernel/projects";
    static final String DISCONNECT_ENDPOINT = "/sso/auth/logout";
    private static final String ACTIVE_API = "/sso/auth/activationStatus";
    @Deprecated
    public static boolean IS_DEBUG = false;
    private Context context;
    private IDP idProvider;
    private Analytics analytics;
    private ArrayList<String> languageCodes;
    private String projectId;
    private SharedElements sharedElements;

    public static void addScope(@NonNull FlybitsScope scope) {
        ScopeOfficer.addScope(scope);
    }

    public static void removeScope(@NonNull FlybitsScope scope) {
        ScopeOfficer.removeScope(scope);
    }

    public static void setLoggingVerbosity(VerbosityLevel level) {
        Logger.setVerbosity(level);
    }

    static int getScopeSize() {
        return ScopeOfficer.getFlybitsScopes().size();
    }

    public static boolean isScopeExists(String scopeName) {
        return ScopeOfficer.getFlybitsScopes().containsKey(scopeName);
    }

    @Deprecated
    public static void setDebug() {
        Logger.setVerbosity(VerbosityLevel.ALL);
    }

    @Deprecated
    public static void unsetDebug() {
        Logger.setVerbosity(VerbosityLevel.NONE);
    }

    private FlybitsManager(Builder builder) {
        String gatewayUrl;
        this.context = builder.mContext;
        this.languageCodes = builder.languageCodes;
        this.idProvider = builder.idProvider;
        this.projectId = builder.projectId;
        this.analytics = new Analytics(this.context);
        this.sharedElements = SharedElementsFactory.INSTANCE.get(this.context);
        if (this.projectId != null) {
            Logger.appendTag(TAG_MANAGER).d("Migrating, and setting project id");
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("flybits_arg_project_id", this.projectId);
            this.sharedElements.migrateData(this.context, args);
            this.sharedElements.setProjectID(this.projectId);
        }
        if (this.languageCodes.size() == 0) {
            this.languageCodes.add("en");
        }
        if (builder.gatewayUrl != null) {
            if (!this.sharedElements.getGatewayURL().equals(builder.gatewayUrl) && !this.sharedElements.getSavedJWTToken().isEmpty()) {
                throw new InvalidFlybitsManagerException("You are trying to change the gateway region with a user already connected to Flybits region: " + this.sharedElements.getGatewayURL() + ". You must disconnect your current session first before changing regions. To do this please create a FlybitsManager with setGatewayUrl of the connected user (the one in this message) and call the disconnect method. After that you will be able to connect to your desired region.");
            }
            gatewayUrl = builder.gatewayUrl;
        } else {
            try {
                ApplicationInfo ai = this.context.getPackageManager().getApplicationInfo(this.context.getPackageName(), 128);
                Bundle bundle = ai.metaData;
                if (bundle.containsKey("com.flybits.project.region")) {
                    String region = bundle.getString("com.flybits.project.region");
                    if (region == null) {
                        throw new InvalidRegionException("This version of the SDK only accepts 'south-america' or 'north-america' value as a region in your AndroidManifest.xml file");
                    }
                    switch (region) {
                        case "south-america": {
                            gatewayUrl = "https://v3-sa.flybits.com";
                            break;
                        }
                        case "north-america": {
                            gatewayUrl = "https://v3.flybits.com";
                            break;
                        }
                        case "develop": {
                            gatewayUrl = "https://dev3.flybits.com";
                            break;
                        }
                        case "staging": {
                            gatewayUrl = "https://v3-staging.flybits.com";
                            break;
                        }
                        default: {
                            throw new InvalidRegionException("This version of the SDK only accepts 'south-america' or 'north-america' value as a region in your AndroidManifest.xml file");
                        }
                    }
                } else {
                    gatewayUrl = "https://v3.flybits.com";
                }
            }
            catch (PackageManager.NameNotFoundException | NullPointerException ex) {
                Logger.exception("FlybitsAPIConstants.getGatewayURL", (Exception)ex);
                gatewayUrl = "https://v3.flybits.com";
            }
        }
        this.sharedElements.setGatewayURL(gatewayUrl);
        this.sharedElements.setLocalization(this.languageCodes);
    }

    @Deprecated
    public BasicResult bindProject(String projectId, BasicResultCallback callback, @NonNull Handler handler) {
        return Project.bindProject(this.context, projectId, callback, handler);
    }

    @Deprecated
    public BasicResult bindProject(String projectId, BasicResultCallback callback) {
        return Project.bindProject(this.context, projectId, callback);
    }

    public BasicResult optOut(BasicResultCallback callback) {
        return this.optOut(callback, new Handler());
    }

    BasicResult optOut(BasicResultCallback callback, Handler handler) {
        return this.setOptedState(false, callback, handler);
    }

    public BasicResult optIn(BasicResultCallback callback) {
        return this.optIn(callback, new Handler());
    }

    BasicResult optIn(BasicResultCallback callback, Handler handler) {
        return this.setOptedState(true, callback, handler);
    }

    BasicResult setOptedState(boolean optedState, BasicResultCallback callback, Handler handler) {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        BasicResult query = new BasicResult(callback, handler, executorService);
        executorService.execute(() -> {
            try {
                Result result = FlyAway.post(this.context, ACTIVE_API, String.format("{\"%s\":%s}", "isActive", optedState), null, "FlybitsManager.setOptedState", null);
                if (result.getStatus() == RequestStatus.COMPLETED) {
                    CommonsDatabase commonsDatabase = CommonsDatabase.getDatabase(this.context);
                    if (!optedState) {
                        this.analytics.destroy();
                        commonsDatabase.ctxDataDAO().deleteAll();
                        commonsDatabase.preferenceDAO().clear();
                        commonsDatabase.cachingEntryDAO().clear();
                    } else {
                        this.analytics.scheduleWorkers();
                    }
                    User user = commonsDatabase.userDao().getActiveUser();
                    if (user != null) {
                        user.setOptedIn(optedState);
                        commonsDatabase.userDao().update(user);
                    }
                    ScopeOfficer.INSTANCE.onOptedStateChange(this.context, optedState);
                }
                query.setResult(result);
            }
            catch (FlybitsException e) {
                query.setResult(new Result(e, "FlybitsManager.optOut() failed."));
            }
        });
        return query;
    }

    BasicResult connect(BasicResultCallback callback, @NonNull Handler handler) {
        return this.connect(callback, true, handler, null);
    }

    public BasicResult connect(BasicResultCallback callback) {
        return this.connect(callback, true);
    }

    @Deprecated
    public BasicResult connect(@NonNull IDP idp, BasicResultCallback callback, boolean autoUseManifestProject) {
        this.idProvider = idp;
        return this.connect(callback, autoUseManifestProject);
    }

    public BasicResult connect(@NonNull IDP idp, BasicResultCallback callback) {
        this.idProvider = idp;
        return this.connect(callback, true);
    }

    public BasicResult connect(@NonNull IDP idp, @NonNull String customerId, BasicResultCallback callback) {
        return this.connect(idp, callback, customerId, new Handler(Looper.getMainLooper()));
    }

    BasicResult connect(@NonNull IDP idp, BasicResultCallback callback, @NonNull String customerId, @NonNull Handler handler) {
        this.idProvider = idp;
        return this.connect(callback, true, handler, customerId);
    }

    BasicResult connect(@NonNull String projectID, @NonNull IDP idp, BasicResultCallback callback, @NonNull Handler handler) {
        SharedElements elements = SharedElementsFactory.INSTANCE.get(this.context);
        if (!projectID.equals(elements.getProjectID()) && !elements.getSavedJWTToken().equals("")) {
            ExecutorService executorService = Executors.newSingleThreadExecutor();
            BasicResult query = new BasicResult(callback, handler, executorService);
            FlybitsException e = new FlybitsException("You must disconnect from your previous IDP if you would like to change your Project ID. Your current ProjectID is: " + projectID + " your previously set ProjectID is: " + projectID);
            query.setFailed(e);
            return query;
        }
        this.idProvider = idp;
        this.sharedElements.setProjectID(projectID);
        return this.connect(callback, true, handler, null);
    }

    public BasicResult connect(@NonNull String projectID, @NonNull IDP idp, BasicResultCallback callback) {
        return this.connect(projectID, idp, callback, new Handler(Looper.getMainLooper()));
    }

    BasicResult connect(BasicResultCallback callback, final boolean autoUseManifestProject, @NonNull Handler handler, final String customerId) {
        final ExecutorService executorService = Executors.newSingleThreadExecutor();
        final BasicResult query = new BasicResult(callback, handler, executorService);
        executorService.execute(() -> {
            if (FlybitsManager.getScopeSize() > 0) {
                FlybitsManager.isConnected(this.context, true, new ConnectionResultCallback(){

                    @Override
                    public void onConnected() {
                        FlybitsException e = new FlybitsException("You already have an IDP connected to the Flybits SDK, please call the disconnect method before calling connect again");
                        query.setFailed(e);
                    }

                    @Override
                    public void notConnected() {
                        executorService.execute(() -> {
                            try {
                                if (FlybitsManager.this.idProvider != null) {
                                    String body2 = FlybitsManager.this.idProvider.getRequestBody(FlybitsManager.this.context, autoUseManifestProject).toString();
                                    String url = FlybitsManager.AUTHENTICATION_API + FlybitsManager.this.idProvider.getAuthenticationEndPoint();
                                    HttpMethod requestType = FlybitsManager.this.idProvider.getRequestType();
                                    Result<User> authenticatedUser = requestType.equals((Object)HttpMethod.GET) ? FlyAway.get(FlybitsManager.this.context, url, FlybitsManager.this.idProvider.getHeaders(), new DeserializeLogin(), "FlybitsManager.connect", User.class) : (requestType.equals((Object)HttpMethod.PUT) ? FlyAway.put(FlybitsManager.this.context, url, body2, new DeserializeLogin(), "FlybitsManager.connect", User.class, FlybitsManager.this.idProvider.getHeaders()) : FlyAway.post(FlybitsManager.this.context, url, body2, new DeserializeLogin(), "FlybitsManager.connect", User.class, FlybitsManager.this.idProvider.getHeaders()));
                                    if (authenticatedUser.getStatus() == RequestStatus.COMPLETED) {
                                        User user = authenticatedUser.getResult();
                                        UserDAO userDAO = CommonsDatabase.getDatabase(FlybitsManager.this.context).userDao();
                                        userDAO.resetAllUsers();
                                        CtxDataDAO ctxDataDAO = CommonsDatabase.getDatabase(FlybitsManager.this.context).ctxDataDAO();
                                        ctxDataDAO.deleteAll();
                                        if (customerId != null && !customerId.isEmpty()) {
                                            user.setCustomerID(customerId);
                                        }
                                        userDAO.insert(user);
                                        FlybitsManager.this.sharedElements.setConnectedIDP(FlybitsManager.this.idProvider.getProvider());
                                        FlybitsManager.this.sharedElements.setUserId(authenticatedUser.getResult().getId());
                                        FlybitsManager.this.idProvider.onAuthenticated(FlybitsManager.this.context, user);
                                        FlybitsManager.this.analytics.scheduleWorkers();
                                        ScopeOfficer.INSTANCE.onConnected(FlybitsManager.this.context, user);
                                    }
                                    query.setResult(authenticatedUser);
                                }
                            }
                            catch (FlybitsException e) {
                                query.setFailed(e);
                            }
                        });
                    }

                    @Override
                    public void onException(@NonNull FlybitsException exception) {
                        query.setFailed(exception);
                    }
                }, handler);
            } else {
                FlybitsException e = new FlybitsException("You need to add at least one FlybitsScope before connecting to the Flybits SDK");
                query.setFailed(e);
            }
        });
        return query;
    }

    public BasicResult connect(BasicResultCallback callback, boolean autoUseManifestProject) {
        if (this.idProvider == null) {
            ExecutorService executorService = Executors.newSingleThreadExecutor();
            BasicResult query = new BasicResult(callback, new Handler(Looper.getMainLooper()), executorService);
            FlybitsException e = new FlybitsException("You must enter an IDP in the Flybits Builder to use this connect() method.");
            callback.onException(e);
            return query;
        }
        return this.connect(callback, autoUseManifestProject, new Handler(Looper.getMainLooper()), null);
    }

    BasicResult destroy(BasicResultCallback callback, @NonNull Handler handler) {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        BasicResult request = new BasicResult(callback, handler, executorService);
        executorService.execute(() -> {
            try {
                this.analytics.flush(null, false);
                String jwtToken = this.sharedElements.getSavedJWTToken();
                Result deleteUser = FlyAway.delete(this.context, "/sso/auth/me", "FlybitsManager.destroy", null);
                if (deleteUser.getStatus() == RequestStatus.COMPLETED) {
                    this.clearSDKData(this.context);
                    ScopeOfficer.INSTANCE.onAccountDestroyed(this.context, jwtToken);
                }
                request.setResult(deleteUser);
            }
            catch (FlybitsException e) {
                request.setFailed(e);
            }
        });
        return request;
    }

    public BasicResult destroy(BasicResultCallback callback) {
        return this.destroy(callback, new Handler(Looper.getMainLooper()));
    }

    public BasicResult disconnect(BasicResultCallback callback) {
        return this.disconnect(callback, false);
    }

    BasicResult disconnect(BasicResultCallback callback, boolean disconnectOnException, @NonNull Handler handler) {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        BasicResult request = new BasicResult(callback, handler, executorService);
        executorService.execute(() -> {
            String jwtToken = this.sharedElements.getSavedJWTToken();
            try {
                this.analytics.flush(null, false);
                Result disconnected = FlyAway.post(this.context, DISCONNECT_ENDPOINT, "", null, "FlybitsManager.disconnect", null);
                if (disconnected.getStatus() == RequestStatus.COMPLETED || disconnectOnException) {
                    this.clearSDKData(this.context);
                    ScopeOfficer.INSTANCE.onDisconnected(this.context, jwtToken);
                    request.setResult(new Result(200, ""));
                } else {
                    request.setResult(disconnected);
                }
            }
            catch (FlybitsException e) {
                if (disconnectOnException) {
                    this.clearSDKData(this.context);
                    ScopeOfficer.INSTANCE.onDisconnected(this.context, jwtToken);
                }
                request.setFailed(e);
            }
        });
        return request;
    }

    BasicResult disconnect(BasicResultCallback callback, @NonNull Handler handler) {
        return this.disconnect(callback, false, handler);
    }

    public BasicResult disconnect(BasicResultCallback callback, boolean disconnectOnException) {
        return this.disconnect(callback, disconnectOnException, new Handler(Looper.getMainLooper()));
    }

    ProjectsResult getProjects(final ProjectParameters params, PagedResultCallback<Project> callback, @NonNull Handler handler) {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        final ProjectsResult result = new ProjectsResult(this.context, params, callback, executorService, handler, this);
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    boolean isConnnected;
                    boolean bl = isConnnected = !FlybitsManager.this.sharedElements.getSavedJWTToken().equals("");
                    if (!isConnnected || !(FlybitsManager.this.getIDP() instanceof FlybitsIDP)) {
                        throw new FlybitsException("Either not yet connected to Flybits, or you are not using the Flybits IDP. GetProjects() only works with the Flybits IDP.");
                    }
                    DeserializeProject singleDeserializaer = new DeserializeProject();
                    DeserializePagedResponse deserializer = new DeserializePagedResponse(singleDeserializaer);
                    Result projectList = FlyAway.get(FlybitsManager.this.context, FlybitsManager.PROJECTS_API, params, deserializer, "FlybitsManager.getProjects");
                    result.setResult(projectList);
                }
                catch (FlybitsException e) {
                    result.setResult(new Result(e, ""));
                }
            }
        });
        return result;
    }

    public ProjectsResult getProjects(ProjectParameters params, PagedResultCallback<Project> callback) {
        return this.getProjects(params, callback, new Handler(Looper.getMainLooper()));
    }

    @Deprecated
    public static ObjectResult<User> getUser(Context context) {
        return User.getSelf(context, null);
    }

    @Deprecated
    static ObjectResult<User> getUser(Context context, ObjectResultCallback<User> callback, @NonNull Handler handler) {
        return User.getSelf(context, callback, handler);
    }

    @Deprecated
    public static ObjectResult<User> getUser(Context context, ObjectResultCallback<User> callback) {
        return User.getSelf(context, callback);
    }

    static ConnectionResult isConnected(final @NonNull Context context, final boolean confirmThroughNetwork, final @NonNull ConnectionResultCallback callback, final @NonNull Handler handler) {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        ConnectionResult query = new ConnectionResult(callback, handler, executorService);
        final SharedElements sharedElements = SharedElementsFactory.INSTANCE.get(context);
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                if (confirmThroughNetwork && !sharedElements.getSavedJWTToken().equals("")) {
                    try {
                        FlyJWT jwt = FlyJWT.Companion.get(context);
                        final Result<?> getJWT = jwt.refresh();
                        handler.post(new Runnable(){

                            @Override
                            public void run() {
                                if (getJWT.getStatus() == RequestStatus.NOT_CONNECTED) {
                                    callback.notConnected();
                                } else if (getJWT.getStatus() == RequestStatus.COMPLETED) {
                                    callback.onConnected();
                                } else {
                                    callback.onException(getJWT.getException());
                                }
                            }
                        });
                    }
                    catch (FlybitsException e) {
                        handler.post(new Runnable(){

                            @Override
                            public void run() {
                                callback.onException(e);
                            }
                        });
                    }
                } else if (sharedElements.getSavedJWTToken().equals("")) {
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            callback.notConnected();
                        }
                    });
                } else {
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            callback.onConnected();
                        }
                    });
                }
            }
        });
        return query;
    }

    public static ConnectionResult isConnected(@NonNull Context context, boolean confirmThroughNetwork, @NonNull ConnectionResultCallback callback) {
        return FlybitsManager.isConnected(context, confirmThroughNetwork, callback, new Handler(Looper.getMainLooper()));
    }

    public ObjectResult<CustomerStatus> checkCustomerIdStatus(@NonNull String customerId, ObjectResultCallback<CustomerStatus> callback) {
        return this.checkCustomerIdStatus(customerId, callback, new Handler(Looper.getMainLooper()));
    }

    ObjectResult<CustomerStatus> checkCustomerIdStatus(@NonNull String customerId, ObjectResultCallback<CustomerStatus> callback, Handler handler) {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        ObjectResult<CustomerStatus> query = new ObjectResult<CustomerStatus>(callback, handler, executorService);
        String savedJwt = this.sharedElements.getSavedJWTToken();
        executorService.execute(() -> {
            UserDAO userDAO = CommonsDatabase.getDatabase(this.context).userDao();
            if (!savedJwt.isEmpty()) {
                Jwt jwt = Jwt.decodeJWTToken(savedJwt);
                long timeEpochTimeSeconds = new Date().getTime() / 1000L;
                User user = userDAO.getSingleByUserAndCustomerId(jwt.getUserID(), customerId);
                if (user != null) {
                    if (user.isOptedIn() && jwt.getExpiry() > timeEpochTimeSeconds) {
                        query.setSuccess(CustomerStatus.CONNECTED_OPTED_IN);
                    } else if (user.isOptedIn() && jwt.getExpiry() < timeEpochTimeSeconds) {
                        query.setSuccess(CustomerStatus.CONNECTED_OPTED_IN_EXPIRED_TOKEN);
                    } else if (!user.isOptedIn() && jwt.getExpiry() > timeEpochTimeSeconds) {
                        query.setSuccess(CustomerStatus.CONNECTED_OPTED_OUT);
                    } else if (!user.isOptedIn() && jwt.getExpiry() < timeEpochTimeSeconds) {
                        query.setSuccess(CustomerStatus.CONNECTED_OPTED_OUT_EXPIRED_TOKEN);
                    }
                } else {
                    user = userDAO.getSingleByCustomerId(customerId);
                    if (user != null) {
                        if (user.isOptedIn()) {
                            query.setSuccess(CustomerStatus.NOT_CONNECTED_OPTED_IN);
                        } else if (!user.isOptedIn()) {
                            query.setSuccess(CustomerStatus.NOT_CONNECTED_OPTED_OUT);
                        }
                    } else {
                        query.setSuccess(CustomerStatus.NOT_CONNECTED);
                    }
                }
            } else {
                query.setSuccess(CustomerStatus.NOT_CONNECTED);
            }
        });
        return query;
    }

    IDP getIDP() {
        return this.idProvider;
    }

    void clearSDKData(Context context) {
        this.analytics.destroy();
        SharedElements sharedElements = SharedElementsFactory.INSTANCE.get(context);
        CommonsDatabase commonsDatabase = CommonsDatabase.getDatabase(context);
        User user = commonsDatabase.userDao().getActiveUser();
        if (user != null) {
            user.setActive(false);
            commonsDatabase.userDao().update(user);
        }
        commonsDatabase.ctxDataDAO().deleteAll();
        commonsDatabase.preferenceDAO().clear();
        commonsDatabase.cachingEntryDAO().clear();
        sharedElements.setJWTToken("");
        sharedElements.setConnectedIDP("");
    }

    public static final class Builder {
        private final Set<FlybitsScope> listOfScopes;
        private Context mContext;
        private IDP idProvider;
        private ArrayList<String> languageCodes;
        private String projectId;
        private String gatewayUrl;

        public Builder(@NonNull Context context) {
            this.mContext = context;
            this.listOfScopes = new HashSet<FlybitsScope>();
            this.languageCodes = new ArrayList();
            try {
                this.languageCodes.add(Locale.getDefault().getLanguage());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Deprecated
        public Builder addScope(@NonNull FlybitsScope scope) {
            this.listOfScopes.add(scope);
            return this;
        }

        public FlybitsManager build() throws InvalidFlybitsManagerException {
            this.checkIfFieldsSet();
            for (FlybitsScope listOfScope : this.listOfScopes) {
                FlybitsManager.addScope(listOfScope);
            }
            return new FlybitsManager(this);
        }

        public Builder setAccount(IDP idp) {
            this.idProvider = idp;
            return this;
        }

        @Deprecated
        public Builder setDebug() {
            FlybitsManager.setLoggingVerbosity(VerbosityLevel.ALL);
            return this;
        }

        public Builder setGateway(@NonNull Region region) {
            this.gatewayUrl = region.getUrl();
            return this;
        }

        public Builder setGatewayURL(@NonNull String gatewayUrl) {
            this.gatewayUrl = gatewayUrl;
            return this;
        }

        public Builder setLanguage(@NonNull String languageCode) {
            this.languageCodes.clear();
            this.languageCodes.add(languageCode);
            return this;
        }

        public Builder setProjectId(@NonNull String projectId) {
            this.projectId = projectId;
            return this;
        }

        private void checkIfFieldsSet() throws InvalidFlybitsManagerException {
            if (this.languageCodes.size() > 0 && this.languageCodes.get(0).length() != 2) {
                throw new InvalidFlybitsManagerException("Your language must be a 2-letter code. Make sure you call setLanguage(String)");
            }
        }
    }
}

