package com.flybits.commons.library.api

import com.flybits.commons.library.BuildConfig

/**
 * The Region defines which Flybits deployment your application will be targeting.
 */
enum class Region(val url : String){

    /**
     * Target the Europe region
     */
    EUROPE(BuildConfig.GATEWAY_EUROPE),

    /**
     * Target the South America region
     */
    SOUTH_AMERICA(BuildConfig.GATEWAY_SA),

    /**
     * Target the Canada region
     */
    CANADA(BuildConfig.GATEWAY_CANADA),

    /**
     * Target the US region
     */
    US(BuildConfig.GATEWAY);
}