package com.flybits.commons.library

import android.content.Context
import android.content.SharedPreferences
import com.flybits.commons.library.utils.Utilities
import com.flybits.internal.db.UserDAO

/**
 * Instances of this class will not encrypt any information stored within it.
 *
 * @param sharedPreferences [SharedPreferences] to be used for storing keys and values.
 *
 * @param userDAO [UserDAO] for retrieving and storing user data.
 */
class UnsecuredSharedElements internal constructor(sharedPreferences: SharedPreferences, userDAO: UserDAO): SharedElements(sharedPreferences, userDAO) {

    override fun performMigration(context: Context, args: Map<String, String>): Int {

        //get all values from backup pref and move to current unsecured pref
        val backupPreferences = context.getSharedPreferences(FLYBITS_STORAGE_UNENCRYPTED_V1, Context.MODE_PRIVATE)
        var migratedCount = 0

        if (backupPreferences.contains(PREF_JWT_TOKEN)) {
            setJWTToken(backupPreferences.getString(PREF_JWT_TOKEN, "") ?: "")
            migratedCount++
        }
        if (backupPreferences.contains(PREF_PROJECT_ID)) {
            setProjectID(backupPreferences.getString(PREF_PROJECT_ID, "") ?: "")
            migratedCount++
        }
        if (backupPreferences.contains(PREF_IDP_CONNECTED)){
            setConnectedIDP(backupPreferences.getString(PREF_IDP_CONNECTED, "") ?: "")
            migratedCount++
        }
        if (backupPreferences.contains(PREF_LANGUAGE_CODES)) {
            setLocalization(Utilities.convertLocalizationStringToList(backupPreferences.getString(PREF_LANGUAGE_CODES, "")))
            migratedCount++
        }
        //no need to migrate gateway URL since it didn't exist yet

        if (migratedCount > 0) {
            backupPreferences.edit().clear().apply()
        }

        return migratedCount
    }
}