/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.internal.db;

import android.database.Cursor;
import androidx.annotation.NonNull;
import androidx.lifecycle.ComputableLiveData;
import androidx.lifecycle.LiveData;
import androidx.room.EntityInsertionAdapter;
import androidx.room.InvalidationTracker;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.flybits.internal.db.PreferenceDAO;
import com.flybits.internal.db.models.Preference;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public final class PreferenceDAO_Impl
implements PreferenceDAO {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter __insertionAdapterOfPreference;
    private final SharedSQLiteStatement __preparedStmtOfClear;
    private final SharedSQLiteStatement __preparedStmtOfDeleteByPrefKey;
    private final SharedSQLiteStatement __preparedStmtOfDeleteByKeyAndValue;

    public PreferenceDAO_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfPreference = new EntityInsertionAdapter<Preference>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `preferences`(`prefKey`,`value`) VALUES (?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, Preference value) {
                if (value.getPrefKey() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getPrefKey());
                }
                if (value.getValue() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getValue());
                }
            }
        };
        this.__preparedStmtOfClear = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "Delete from preferences";
                return "Delete from preferences";
            }
        };
        this.__preparedStmtOfDeleteByPrefKey = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "Delete from preferences WHERE prefKey = ?";
                return "Delete from preferences WHERE prefKey = ?";
            }
        };
        this.__preparedStmtOfDeleteByKeyAndValue = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "Delete from preferences WHERE value = ? AND prefKey = ?";
                return "Delete from preferences WHERE value = ? AND prefKey = ?";
            }
        };
    }

    @Override
    public void insert(Preference entry) {
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfPreference.insert((Object)entry);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(List<Preference> entry) {
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfPreference.insert(entry);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void clear() {
        SupportSQLiteStatement _stmt = this.__preparedStmtOfClear.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfClear.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteByPrefKey(String key) {
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteByPrefKey.acquire();
        this.__db.beginTransaction();
        try {
            int _argIndex = 1;
            if (key == null) {
                _stmt.bindNull(_argIndex);
            } else {
                _stmt.bindString(_argIndex, key);
            }
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteByPrefKey.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteByKeyAndValue(String key, String value) {
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteByKeyAndValue.acquire();
        this.__db.beginTransaction();
        try {
            int _argIndex = 1;
            if (value == null) {
                _stmt.bindNull(_argIndex);
            } else {
                _stmt.bindString(_argIndex, value);
            }
            _argIndex = 2;
            if (key == null) {
                _stmt.bindNull(_argIndex);
            } else {
                _stmt.bindString(_argIndex, key);
            }
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteByKeyAndValue.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getIdsByKey(String key) {
        String _sql = "SELECT value FROM preferences WHERE prefKey = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT value FROM preferences WHERE prefKey = ?", (int)1);
        int _argIndex = 1;
        if (key == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, key);
        }
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            ArrayList<String> _result = new ArrayList<String>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _item = _cursor.getString(0);
                _result.add(_item);
            }
            ArrayList<String> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Preference> getIdsByKeyAndValue(String key, String value) {
        String _sql = "SELECT * FROM preferences WHERE prefKey = ? AND value = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM preferences WHERE prefKey = ? AND value = ?", (int)2);
        int _argIndex = 1;
        if (key == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, key);
        }
        _argIndex = 2;
        if (value == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, value);
        }
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            int _cursorIndexOfPrefKey = _cursor.getColumnIndexOrThrow("prefKey");
            int _cursorIndexOfValue = _cursor.getColumnIndexOrThrow("value");
            ArrayList<Preference> _result = new ArrayList<Preference>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _tmpPrefKey = _cursor.getString(_cursorIndexOfPrefKey);
                String _tmpValue = _cursor.getString(_cursorIndexOfValue);
                Preference _item = new Preference(_tmpPrefKey, _tmpValue);
                _result.add(_item);
            }
            ArrayList<Preference> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    public LiveData<List<String>> getLiveValues(String key) {
        String _sql = "SELECT value FROM preferences WHERE prefKey = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT value FROM preferences WHERE prefKey = ?", (int)1);
        int _argIndex = 1;
        if (key == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, key);
        }
        return new ComputableLiveData<List<String>>(this.__db.getQueryExecutor()){
            private InvalidationTracker.Observer _observer;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected List<String> compute() {
                if (this._observer == null) {
                    this._observer = new InvalidationTracker.Observer("preferences", new String[0]){

                        public void onInvalidated(@NonNull Set<String> tables) {
                            this.invalidate();
                        }
                    };
                    PreferenceDAO_Impl.this.__db.getInvalidationTracker().addWeakObserver(this._observer);
                }
                try (Cursor _cursor = PreferenceDAO_Impl.this.__db.query((SupportSQLiteQuery)_statement);){
                    ArrayList<String> _result = new ArrayList<String>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        String _item = _cursor.getString(0);
                        _result.add(_item);
                    }
                    ArrayList<String> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        }.getLiveData();
    }
}

