/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.caching;

import androidx.annotation.Nullable;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.Observer;

public abstract class FlybitsUIObjectObserver<T> {
    private DataChanged<T> callback;
    private LiveData<T> item;
    private Observer<T> observer;

    protected void add(DataChanged<T> callback) {
        this.callback = callback;
    }

    @Nullable
    protected LiveData<T> getData() {
        return this.item;
    }

    public void remove() {
        if (this.item != null && this.item.hasActiveObservers()) {
            this.item.removeObserver(this.observer);
        }
    }

    protected void setItem(LiveData<T> item) {
        this.item = item;
        this.observer = new Observer<T>(){

            public void onChanged(@Nullable T t) {
                if (FlybitsUIObjectObserver.this.callback != null) {
                    FlybitsUIObjectObserver.this.callback.onUpdate(t);
                }
            }
        };
        this.item.observeForever(this.observer);
    }

    public static interface DataChanged<T> {
        public void onUpdate(@Nullable T var1);
    }
}

