package com.flybits.internal.db.models;

import androidx.room.ColumnInfo;
import androidx.room.Entity;
import androidx.room.Ignore;
import androidx.room.Index;
import androidx.room.PrimaryKey;
import androidx.annotation.NonNull;

@Entity(tableName = "cachingentry", indices={@Index(value={"cachingkey", "contentID"}, unique=true)})
public class CachingEntry {

    @ColumnInfo(name = "cachingkey")
    @NonNull
    private String cachingKey;

    @ColumnInfo(name = "contentID")
    @NonNull
    private String contentId;

    @ColumnInfo(name = "sequence")
    @PrimaryKey(autoGenerate = true)
    private int sequence;

    public CachingEntry (){}

    @Ignore
    public CachingEntry (@NonNull String cachingKey, @NonNull String contentId){
        this.cachingKey     = cachingKey;
        this.contentId      = contentId;
    }

    public String getCachingKey() {
        return cachingKey;
    }

    public void setCachingKey(String cachingKey) {
        this.cachingKey = cachingKey;
    }

    public String getContentId() {
        return contentId;
    }

    public void setContentId(String contentId) {
        this.contentId = contentId;
    }

    public int getSequence() {
        return sequence;
    }

    public void setSequence(int sequence) {
        this.sequence = sequence;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CachingEntry that = (CachingEntry) o;

        return that.contentId.equalsIgnoreCase(contentId)
                && that.cachingKey.equalsIgnoreCase(cachingKey);
    }
}
