package com.flybits.internal.db

import androidx.room.Dao
import androidx.room.Delete
import androidx.room.Insert
import androidx.room.OnConflictStrategy.REPLACE
import androidx.room.Query
import com.flybits.commons.library.models.CtxData

@Dao
interface CtxDataDAO {
    @Query("SELECT * from ctxData")
    fun getAll(): List<CtxData>

    @Insert(onConflict = REPLACE)
    fun insert(basicData: CtxData)

    @Query("DELETE from ctxData")
    fun deleteAll()

    @Delete
    fun deleteMany(ctxData: Collection<CtxData>)
}