package com.flybits.commons.library.models.internal;

import androidx.annotation.NonNull;

import java.util.ArrayList;

/**
 * The {@code PagedResponse} class is response for containing information about a result from a
 * network request that is expected to have a network request that returns a list of object as well
 * as a {@link Pagination} object.
 *
 * @param <T> Any entity found within the Flybits ecosystem.
 */
public class PagedResponse<T> {

    private ArrayList<T> items;
    private Pagination pagination;

    /**
     * Default Constructor which sets the returned items and the {@link Pagination} object
     * associated to this network request.
     *
     * @param items The list of items returned for the network request.
     * @param pagination The {@link Pagination} object returned for the network request.
     */
    public PagedResponse(@NonNull ArrayList<T> items, @NonNull Pagination pagination) {
        this.items = items;
        this.pagination = pagination;
    }

    /**
     * Get the list of items associated to the the network request.
     * @return The list of items
     */
    public ArrayList<T> getItems() {
        return items;
    }

    /**
     * Get the {@link Pagination} object associated to the list of items returned in the network
     * request.
     *
     * @return The {@link Pagination} object.
     */
    public Pagination getPagination() {
        return pagination;
    }
}
